<?php
namespace App\Controllers\Api;

use App\Controllers\Admin\Gate;
use App\Models\NotesModel;
use CodeIgniter\RESTful\ResourceController;
use App\Models;
use App\Models\ComplainModel;
use App\Models\CommonWebServiceModel;
use App\Models\SocietyModel;
use App\Models\FlatModel;
use App\Models\TowerModel;
use App\Models\VisitorCompanyModel;
use App\Models\CategoryModel;
use App\Models\MeetingModel;
use App\Models\OwnershipFlatModel;
use App\Models\ParkingSlotModel;
use App\Models\VisitorModel;
use App\Models\ResourceModel;
use App\Models\NoticeModel;
use App\Models\StatusModel;
use App\Models\PollModel;
use App\Models\AmenitiesModel;
use App\Models\BannerModel;
use App\Models\DocumentFolderModel;
use App\Models\ManagementCommitteeModel;
use App\Models\NotificationModel;
use App\Models\SettingModel;
use App\Models\FaqModel;
use App\Models\mediaModel;
use App\Models\EventModel;
use App\Models\GeneratorModel;
use App\Models\WaterTankModel;
use App\Models\ResourceTypeModel;
use Firebase\JWT\JWT;
use CodeIgniter\HTTP\IncomingRequest;
use DateTime;
helper('text');

class SocietyApi extends ResourceController
{
    protected $complainModel;
    protected $amenitiesModel;
    protected $commonWebserviceModel;
    protected $ownershipFlatModel;
    protected $parkingSlotModel;
    protected $flatModel;
    protected $towerModel;
    protected $visitorCompanyModel;
    protected $categoryModel;
    protected $societyModel;
    protected $meetingModel;
    protected $statusModel;
    protected $visitorModel;
    protected $resourceModel;
    protected $noticeModel;
    protected $pollModel;
    protected $eventModel;
    protected $bannerModel;
    protected $managementCommitteeModel;
    protected $settingModel;
    protected $notificationModel;
    protected $documentFolderModel;
    protected $faqModel;
    protected $forumModel;
    protected $generatorModel;
    protected $waterTankModel;
    protected $resourceTypeModel;
    protected $managementCommitteeResponsibilitiesModel;
    protected $dt_ci_acl;

    public function __construct()
    {
        $this->managementCommitteeModel = new ManagementCommitteeModel();
        $this->complainModel = new ComplainModel();
        $this->amenitiesModel = new AmenitiesModel();
        $this->flatModel = new FlatModel();
        $this->meetingModel = new MeetingModel();
        $this->resourceTypeModel = new ResourceTypeModel();
        $this->towerModel = new TowerModel();
        $this->visitorCompanyModel = new VisitorCompanyModel();
        $this->categoryModel = new CategoryModel();
        $this->eventModel = new EventModel();
        $this->visitorModel = new VisitorModel();
        $this->resourceModel = new ResourceModel();
        $this->noticeModel = new NoticeModel();
        $this->pollModel = new PollModel();
        $this->commonWebserviceModel = new CommonWebServiceModel();
        $this->statusModel = new StatusModel();
        $this->societyModel = new SocietyModel();
        $this->ownershipFlatModel = new OwnershipFlatModel();
        $this->rentalModel = new Models\RentalsModel();
        $this->parkingSlotModel = new ParkingSlotModel();
        $this->notificationModel = new NotificationModel();
        $this->amenitiesModel = new Models\AmenitiesModel();
        $this->bookingModel = new Models\BookingModel();
        $this->vendorModel = new Models\VendorModel();
        $this->managementCommitteeModel = new Models\ManagementCommitteeModel();
        $this->managementCommitteeResponsibilitiesModel = new Models\ManagementCommitteeResponsibilitiesModel();
        $this->sosModel = new Models\SosModel();
        $this->staffModel = new Models\StaffModel();
        $this->bannerModel = new Models\BannerModel();
        $this->documentFolderModel = new Models\DocumentFolderModel();
        $this->settingModel = new Models\SettingModel();
        $this->faqModel = new Models\FaqModel();
        $this->forumModel = new Models\ForumModel();
        $this->mediaModel = new Models\MediaModel();
        $this->parkingAreaModel = new Models\ParkingAreaModel();
        $this->ionAuthModel = new Models\IonAuthModel();
        $this->generatorModel = new Models\GeneratorModel();
        $this->waterTankModel = new Models\WaterTankModel();
        $this->dt_ci_acl    = new \App\Libraries\Dt_ci_acl();
        helper('Dt_ci_site_helper');
        $this->validation = \Config\Services::validation();
        $this->startRtime = microtime(TRUE);
        $this->db = \Config\Database::connect();
        checkAndCreatePath(CATEGORY_IMAGE_PATH);
        checkAndCreatePath(DOCUMENT_IMAGE_PATH);
        checkAndCreatePath(QR_CODE_IMAGE_PATH);
        checkAndCreatePath(VEHICLE_IMAGE_PATH);
        checkAndCreatePath(EVENT_QR_CODE_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_MEDIA_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_EVENT_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_STAFF_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_ID_PROOF_PATH);
        checkAndCreatePath(THUMBNAIL_CATEGORY_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_DOCUMENT_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_COMPLAIN_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_CATEGORY_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_VEHICLE_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_VISITOR_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_RENTALS_IMAGE_PATH);
        checkAndCreatePath(THUMBNAIL_ITEM_IMAGE_PATH);
    }

    public function __destruct()
    {
        // Get the current timestamp
        $this->endRtime = microtime(TRUE);
        // Log the loading time to the log table
        if (REST_ENABLE_LOGGING == TRUE) {
            $this->logAccessTime();
        }
    }

    function checkPin() // Done
    {
        $userId = $this->request->getVar('user_id');
        $pin = $this->request->getVar('pin');
        $appType = $this->request->getVar('app_type');
        // $societyId = $this->request->getVar('society_id');
        $permissionsArray = [];
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('pin', lang('CommonWebService.pin'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'id' => $userId,
            );
            $userData = $this->commonWebserviceModel->getUserSocietyData($filterArray);

            if($appType == GATE_KEEPER){
                $permissionsToCheck = gatekeeperAppPermission();

                $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                    'user_id' => $userId,
                    // 'society_id' => $societyId,
                ));
                if(!empty($userDataPermissionFilter)){
                    $permissions = $userDataPermissionFilter['permissions'];
                    $unserializedData = unserialize($permissions);
                    
                    foreach ($permissionsToCheck as $key => $value) {
                        if(!empty($unserializedData)){
                            if (in_array("MobileGatekeeperApp|$key", $unserializedData)) {
                                $permissionsArray[] = $key;
                            }
                        }
                    }                                    
                }
            }

            $dbPin = isset($userData['pin']) ? $userData['pin'] : 0;
            if (password_verify($pin, $dbPin)) {
                $responseData = true;
            } else {
                $responseData = false;
            }
            if ($responseData) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.pin_verified_successfully'),
                    'data' => null,
                    'user_permission_array' => $permissionsArray,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.invalid_pin'),
                    'data' => null,
                    'user_permission_array' => null,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    function changePin() // Done
    {
        $userId = $this->request->getVar('user_id');
        $oldPin = $this->request->getVar('old_pin');
        $newPin = $this->request->getVar('new_pin');
        $confirmPin = $this->request->getVar('confirm_pin');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('old_pin', lang('CommonWebService.old_pin'), 'required|numeric|exact_length[4]');
        $this->validation->setRule('new_pin', lang('CommonWebService.new_pin'), 'required|numeric|exact_length[4]');
        $this->validation->setRule('confirm_pin', lang('CommonWebService.confirm_pin'), 'required|numeric|exact_length[4]');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'id' => $userId,
            );
            $userData = $this->commonWebserviceModel->getUserSocietyData($filterArray);
            $dbPin = isset($userData['pin']) ? $userData['pin'] : 0;
            if (password_verify($oldPin, $dbPin)) {
                if ($oldPin == $newPin) {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.new_pin_should_be_different_from_old_pin'),
                        'data' => null,
                        'response_code' => 404,
                    );
                    return $this->response($data, 404);
                } else {
                    if ($newPin == $confirmPin) {
                        $filterPin = $this->ionAuthModel->hashPassword($confirmPin);
                        $userPinArray['pin'] = $filterPin;
                        $userPinArray['updated_at'] = date('Y-m-d H:i:s');
                        $userPinArray['updated_by'] = $userData['id'];
                        $responseData = $this->commonWebserviceModel->updateData($userPinArray, 'tbl_user_society', 'user_society_id', $userData['user_society_id']);
                    } else {
                        $data = array(
                            'status' => false,
                            'message' => lang('CommonWebService.confirm_pin_mismatch_new_pin'),
                            'data' => null,
                            'response_code' => 404,
                        );
                        return $this->response($data, 404);
                    }
                }
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.invalid_old_pin'),
                    'data' => null,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
            if ($responseData) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.pin_change_successfully'),
                    'data' => null,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.error_while_changing_pin'),
                    'data' => null,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function addEditComplainTicket()
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $complainId = $this->request->getVar('complain_id');
        $complainTitle = $this->request->getVar('complain_title');
        $complainType = $this->request->getVar('complain_type');
        $categoryId = $this->request->getVar('category_id');
        $towerId = $this->request->getVar('tower_id');
        $description = $this->request->getVar('description');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $appType = $this->request->getVar('app_type');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $isUrgent = $this->request->getVar('is_urgent');
        $complainImage = $this->request->getVar('complain_image[]');
        $complainRecord = $this->request->getVar('complain_record[]');
        $flatId = $this->request->getVar('flat_id');
        $mediaIdArray = $this->request->getVar('media_id_array');
        $this->validation->setRule('complain_type', lang('CommonWebService.complain_type'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('description', lang('CommonWebService.description'), 'required');
        $this->validation->setRule('category_id', lang('CommonWebService.category_id'), 'required');
        // $this->validation->setRule('tower_id', lang('CommonWebService.tower_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        // $this->validation->setRule('flat_id', lang('CommonWebService.flat_id'), 'required');
        if($appType != MANAGER_APP){
            $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        }
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $complainImageDocument = array();
            if (isset($_FILES["complain_image"])) {
                $complainImagePath = MEDIA_IMAGE_PATH;
                $complainImageDocument = $dt_ci_file_upload->UploadMultipleFile('complain_image', MAX_IMAGE_SIZE_LIMIT, $complainImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($complainImageDocument['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($complainImageDocument['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($complainImageDocument['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailMultipleUploadFile($complainImageDocument, MEDIA_IMAGE_PATH, THUMBNAIL_MEDIA_IMAGE_PATH);
                }
            }
            $complainRecordDocument = array();
            if (isset($_FILES["complain_record"])) {
                $complainRecordPath = MEDIA_IMAGE_PATH;
                $complainRecordDocument = $dt_ci_file_upload->UploadMultipleFile('complain_record', MAX_IMAGE_SIZE_LIMIT, $complainRecordPath, true, true, array('mp3', 'mp4'));
                if ($complainRecordDocument['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($complainRecordDocument['message']),
                        'data' => null
                    ), 404);
                }
            }
            if ($complainType == 'personal' && $appType == MEMBER_APP) {
                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_active' => 1,
                    'is_show_all_member' => 1
                ));
                if (!empty($ownershipFlatMemberData)) {
                    if ($ownershipFlatMemberData['tower_id'] != $towerId) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => 'Select Your Own Tower ' . $ownershipFlatMemberData['tower_name'],
                            'data' => null
                        ), 404);
                    }
                }
            }
            $statusId = 0;
            $statusData = $this->statusModel->getStatusData(array(
                'is_default' => 1,
                'status_for' => 'complain',
                'is_active' => 1,
            ));
            if (empty($statusData)) {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => 'Status Master Complain Is Default Status Not Defined',
                    'data' => null
                ), 404);
            }
            if (!empty($statusData)) {
                $statusId = isset($statusData['status_id']) ? $statusData['status_id'] : 0;
            }
            $nextSeries = 'getNextSeries("complain", "' . COMPLAIN_PREFIX . '", "' . $societyId . '")';

            

            $complainUpdateArray = array();
            $complainArray = array(
                'complain_id' => $complainId,
                'complain_type' => $complainType,
                'complain_title' => $complainTitle,
                'category_id' => $categoryId,
                'tower_id' => $towerId,
                'description' => $description,
                'remarks' => $description,
                'society_id' => $societyId,
                'is_active' => 1,
                'status_id' => $statusId,
                'is_urgent' => $isUrgent,
                'complainant' => $appType,
            );
            if ($complainType == 'personal' && $appType == MEMBER_APP) {
                $ownershipFlatMembersData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                ));
                $complainArray['flat_id'] = $ownershipFlatMembersData['flat_id'];
                $complainArray['complainant_id'] = $ownershipFlatMemberId;
            }

            if($appType == MANAGER_APP){
                if ($complainType == 'personal'){
                    $complainArray['flat_id'] = $flatId;
                    $complainArray['complainant_id'] = $userId;
                }
            }
            

            if ($complainId == '') {
                $complainArray['prefix'] = COMPLAIN_PREFIX;
                $complainArray['series'] = $nextSeries;
            }
            if (!empty($complainId)) {
                $complainUpdateData = $this->complainModel->getComplainData(array(
                    'complain_id' => $complainId,
                ));
                $complainUpdateArray = compareArray($complainArray, $complainUpdateData);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $complainData = $this->commonWebserviceModel->insertUpdateRecord($complainArray, 'complain_id', 'tbl_complain', 1, '', array('series'), $extraData, $complainUpdateArray);
            $lastComplainId = $complainData['lastInsertedId'];
            if ($lastComplainId != '') {
                if (isset($complainImageDocument) && count($complainImageDocument) > 0) {
                    $batchArray = array();
                    unset($complainImageDocument['success']);
                    foreach ($complainImageDocument as $key => $imageData) {
                        $dataArray = array(
                            'media_id' => '',
                            'media_for_id' => $lastComplainId,
                            'media_for' => 'complain',
                            'media_type' => 'image',
                            'media_file' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                            'created_by' => $userId,
                            'updated_by' => $userId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $complainExtraDataArray = array();
                    $complainExtraDataArray['module_id'] = $lastComplainId;
                    $complainExtraDataArray['module'] = 'Complain Media Image';
                    $complainExtraDataArray['type'] = 'Complain';
                    $complainExtraDataArray['old_data'] = '';
                    $complainExtraDataArray['user_id'] = $userId;
                    $complainExtraDataArray['society_id'] = $societyId;
                    $this->complainModel->batchInsert($batchArray, 'tbl_media', $complainExtraDataArray);
                }
                if (isset($complainRecordDocument) && count($complainRecordDocument) > 0) {
                    $batchArray = array();
                    unset($complainRecordDocument['success']);
                    foreach ($complainRecordDocument as $key => $RecordData) {
                        $dataArray = array(
                            'media_id' => '',
                            'media_for_id' => $lastComplainId,
                            'media_for' => 'complain',
                            'media_type' => 'audio',
                            'media_file' => isset($RecordData['file_name']) ? $RecordData['file_name'] : "",
                            'created_by' => $userId,
                            'updated_by' => $userId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $complainExtraDataArray = array();
                    $complainExtraDataArray['module_id'] = $lastComplainId;
                    $complainExtraDataArray['module'] = 'Complain Media Record';
                    $complainExtraDataArray['type'] = 'Complain';
                    $complainExtraDataArray['old_data'] = '';
                    $complainExtraDataArray['user_id'] = $userId;
                    $complainExtraDataArray['society_id'] = $societyId;
                    $this->complainModel->batchInsert($batchArray, 'tbl_media', $complainExtraDataArray);
                }
            }
            if(isset($mediaIdArray) && !empty($mediaIdArray)){
                $this->complainModel->deleteMediaRecord($mediaIdArray);
            }
            $complainRecord = $this->complainModel->getComplainData(array(
                'complain_id' => $lastComplainId,
            ));
            if ($complainId == '') {
               $memberIdArray = array();
               $notificationDataArray = array();

               $complainForName = (isset($complainRecord['complainant_name']) && $complainRecord['complainant_name'] != "") ? $complainRecord['complainant_name'] : $complainRecord['created_by'];
                $userDeviceUserIdArray = array();
                $userDeviceUserTypeIdArray = array();
                $userManagerDevice = array();
                $userDeviceManagerIdArray = array();
                $userDeviceManagerTypeIdArray = array();
                $userDeviceManagerTypeArray = array();
                $userDeviceUserTypeArray = array();
                $managementCommitteeData = $this->managementCommitteeModel->getManagementCommitteeData(array(
                    'society_id' => $societyId,
                    'is_api' => 1,
                    'is_multiple' => 1
                ));

                if (!empty($managementCommitteeData)) {
                    foreach ($managementCommitteeData as $managementCommitteeElement) {
                        $memberIdArray[] = $managementCommitteeElement['member_id'];
                    }
                }

                // printArray($ownershipFlatMemberId,1);
                if (!empty($memberIdArray)) {
                    $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => 'Member',
                        'society_id' => $societyId,
                    ));

                    $resourceTypeManagerData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => 'Manager',
                        'society_id' => $societyId,
                    ));

                    if($appType == MANAGER_APP){
                        $resourceTypeIdNot = $resourceTypeManagerData['resource_type_id'];
                    }
                    else{
                        $resourceTypeIdNot = $resourceTypeData['resource_type_id'];
                    }
                    $userSocietyCommitteeData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'society_id' => $societyId,
                        'resource_type_id' => $resourceTypeData['resource_type_id'],
                        'type_id' => $memberIdArray,
                        'resource_type_id_not' => $resourceTypeIdNot,
                        'user_id_not' => $userId,
                        //'is_management_committee' => 1,
                        // 'is_user_device_token_get' => 1,
                        'is_multiple' => 1
                    ));

                    if (!empty($userSocietyCommitteeData)) {
                        foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
                            $userDeviceUserIdArray[] = isset($userSocietyCommitteeElement['user_id']) ? $userSocietyCommitteeElement['user_id'] : 0;
                            $userDeviceUserTypeIdArray[] = isset($userSocietyCommitteeElement['type_id']) ? $userSocietyCommitteeElement['type_id'] : 0;
                            $userDeviceUserTypeArray[] = $resourceTypeData['resource_type_id'];
                        }


                        $userMemberDevice = $this->commonWebserviceModel->deviceData(array(
                            "user_id" => $userDeviceUserIdArray,
                            "user_type_id" => $userDeviceUserTypeIdArray,
                            "resource_type_id" => $userDeviceUserTypeArray,
                            "is_latest" => 1,
                            "is_multiple" => 1
                        ));

                        

                        $userManagerData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'user_id_not' => $userId,
                            'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                            'resource_type_id_not' => $resourceTypeIdNot,
                            'is_multiple' => 1
                        ));

                        // printArray($userManagerData,1);

                        if (!empty($userManagerData)) {
                            foreach ($userManagerData as $userManagerCommittee) {
                                $userDeviceManagerIdArray[] = isset($userManagerCommittee['user_id']) ? $userManagerCommittee['user_id'] : 0;
                                $userDeviceManagerTypeIdArray[] = isset($userManagerCommittee['type_id']) ? $userManagerCommittee['type_id'] : 0;
                                $userDeviceManagerTypeArray[] = $resourceTypeManagerData['resource_type_id'];
                            }

                            $userManagerDevice = $this->commonWebserviceModel->deviceData(array(
                                "user_id" => $userDeviceManagerIdArray,
                                "user_type_id" => $userDeviceManagerTypeIdArray,
                                "resource_type_id" => $userDeviceManagerTypeArray,
                                "is_latest" => 1,
                                "is_multiple" => 1
                            ));
                        }
                        $userMergeArray = array_merge($userMemberDevice,$userManagerDevice);

                        // printArray($userSocietyCommitteeData,1);
                        if (!empty($userMergeArray)) {
                            foreach ($userMergeArray as $userDeviceElement) {
                                if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['player_id'] != '') {
                                    $notificationArray = array(
                                        'ownership_flat_id' => 0,
                                        'ownership_flat_member_id' => isset($userDeviceElement['type_id']) ? $userDeviceElement['type_id'] : 0,
                                        'type' => 'complain',
                                        'status' => 'complain',
                                        'type_id' => $lastComplainId,
                                        'user_id' => $userId,
                                        'complain_title' => $complainRecord['complain_title'],
                                        'complain_number' => $complainRecord['complain_number'],
                                        'description' => $complainRecord['description'],
                                        'member_name' => $complainRecord['complainant_name'],
                                        'society_id' => $societyId,
                                        'notification_title' => 'New Complain Registered',
                                        'description' => 'A new complain has been registered by '.$complainForName.' regarding '.$complainTitle.'. Please review the details and take appropriate action.',
                                        'module' => 'complain',
                                        'action_type' => 'send',
                                        'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                        'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                        'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                        'player_id' => isset($userDeviceElement['player_id']) ? $userDeviceElement['player_id'] : '',
                                        // 'app_url' => MEMBER_URL .'ticket_detail_page/' . $lastComplainId,
                                    );

                                    if ($appType == MANAGER_APP) {
                                        $notificationArray['send_for_notification'] = $appType;
                                        $notificationArray['send_for_notification_id'] = $userId;
                                        $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : '';
                                        $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        $notificationArray['app_url'] = MANAGER_URL .'ticket_detail_page/' . $lastComplainId ;
                                    }

                                    if ($appType == MEMBER_APP) {
                                        $notificationArray['send_for_notification'] = $appType;
                                        $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                        $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : '';
                                        $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        $notificationArray['app_url'] = MEMBER_URL .'ticket_detail_page/' . $lastComplainId ;
                                    }
                                    $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                    array_push($notificationDataArray, $notificationArray);
                                }
                            }
                        }
                    }

                    if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        sendNotificationComplainAndroid($notificationDataArray);
                    }
                }
                
            }
            if (!empty($complainRecord)) {
                $complainRecord["complain_number"] = $complainRecord['prefix'] . $complainRecord['series'];
            }



            $complainMediaDataWise = array();
            $complainHistoryDataWise = array();
            $complainHistoryMediaDataWise = array();
            $complainFilterArray = array(
                'complain_id' => $lastComplainId,
            );
            $complainInsertData = $this->complainModel->getComplainData($complainFilterArray);
            $objectFilterData = array(
                'tower_id' => array('tower_id', 'tower_name'),
                'category_id' => array('category_id', 'category_name'),
                'status_id' => array('status_id', 'status_name'),
                'flat_id' => array('flat_id', 'flat_no','tower_flat_name'),
            );
            
            if(!empty($complainInsertData)){
                $complainHistoryData = $this->complainModel->getComplainHistoryData(array(
                    'complain_id'=> $lastComplainId,
                    'is_multiple' => 1,
                ));
                if(!empty($complainHistoryData)){
                    foreach($complainHistoryData as $chKey => $complainHistory){
                        $complainHistoryIdArray[] = $complainHistory['complain_history_id'];
                    }
                }
                if(!empty($complainHistoryIdArray)){
                    $complainHistoryMediaData = $this->complainModel->getComplainHistoryImageData(array(
                        "complain_history_id" => $complainHistoryIdArray,
                        "is_multiple" => 1,
                    ));
                    if(!empty($complainHistoryMediaData)) {
                        foreach ($complainHistoryMediaData as $complainHistoryMediaElement) {
                            if ($complainHistoryMediaElement["complain_image"] == '') {
                                $complainHistoryMediaElement["complain_image"] = SITE_URL('uploads/no_image.png');
                                $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                if($complainHistoryMediaElement['media_type'] == 'image'){
                                    $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $complainHistoryMediaElement["complain_image"];
                                }
                                else{
                                    $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL('uploads/no_image.png');
                                }
                                $complainHistoryMediaElement["complain_image"] = SITE_URL() . MEDIA_IMAGE_PATH . $complainHistoryMediaElement["complain_image"];
                            }
                            $complainHistoryMediaDataWise[$complainHistoryMediaElement['complain_history_id']][] = $complainHistoryMediaElement;
                        }
                    }  
                }
                if(!empty($complainHistoryData)) {
                    foreach ($complainHistoryData as $chKey => $complainHistoryElement) {
                        $complainHistoryData[$chKey]['created_at_display'] = time_elapsed_string($complainHistoryElement['created_at']);
                        $complainHistoryData[$chKey]['updated_at_display'] = time_elapsed_string($complainHistoryElement['updated_at']);
                        $complainHistoryData[$chKey]['complain_history_image_data'] = array_key_exists($complainHistoryElement['complain_history_id'],$complainHistoryMediaDataWise) ? $complainHistoryMediaDataWise[$complainHistoryElement['complain_history_id']]: array();                    
                    }
                }
                if(!empty($complainHistoryData)) {
                    foreach ($complainHistoryData as $complainHistoryElement) {
                        $complainHistoryDataWise[$complainHistoryElement['complain_id']][] = $complainHistoryElement; 
                    }
                }
                $mediaData = $this->complainModel->getMediaData(array(
                    "media_for_id" => $lastComplainId,
                    "media_for" => 'complain',
                    "is_multiple" => 1,
                ));
                if(!empty($mediaData)) {
                    foreach ($mediaData as $mediaElement) {
                        if ($mediaElement["media_file"] == '') {
                            $mediaElement["media_file"] = SITE_URL('uploads/no_image.png');
                            $mediaElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                        } else {
                            $mediaElement["thumbnail_media_file"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $mediaElement["media_file"];
                            $mediaElement["media_file"] = SITE_URL() . MEDIA_IMAGE_PATH . $mediaElement["media_file"];
                        }
                        $complainMediaDataWise[$mediaElement['media_for_id']][] = $mediaElement;
                    }
                }
            }
            if (!empty($complainInsertData)) {
                $complainInsertData = getModuleObjectData($objectFilterData, $complainInsertData);
                $complainInsertData['created_at'] = YMDToDMY($complainInsertData["created_at"], true);
                $complainInsertData['updated_at'] = YMDToDMY($complainInsertData["updated_at"], true);
                $complainInsertData['created_at_display'] = time_elapsed_string($complainInsertData['created_at']);
                $complainInsertData['updated_at_display'] = time_elapsed_string($complainInsertData['updated_at']);
                $complainInsertData['complain_image_data'] = array_key_exists($complainInsertData['complain_id'], $complainMediaDataWise) ? $complainMediaDataWise[$complainInsertData['complain_id']] : array();
                $complainInsertData['complain_history_data'] = array_key_exists($complainInsertData['complain_id'],$complainHistoryDataWise) ? $complainHistoryDataWise[$complainInsertData['complain_id']]: array();

                if($complainInsertData['complain_created_by'] == $userId){
                    $complainInsertData['is_complain_created_by_me'] = 1;
                } else {
                    $complainInsertData['is_complain_created_by_me'] = 0;
                }
            }

            if (isset($complainId) && !empty($complainId)) {
                if (isset($complainData['success']) && $complainData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.complain')),
                        'data' => $complainInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.complain')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($complainData['success']) && $complainData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.complain')),
                        'data' => $complainInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.complain')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function addEditComplainHistory()
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $complainId = $this->request->getVar('complain_id');
        $statusId = $this->request->getVar('status_id');
        $societyId = $this->request->getVar('society_id');
        $remarks = $this->request->getVar('remarks');
        $appType = $this->request->getVar('app_type');
        $userId = $this->request->getVar('user_id');
        $complainImage = $this->request->getVar('complain_image[]');
        
        $this->validation->setRule('remarks', lang('CommonWebService.remarks'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $complainImageDocument = array();
            if (isset($_FILES["complain_image"])) {
                $complainImagePath = MEDIA_IMAGE_PATH;
                $complainImageDocument = $dt_ci_file_upload->UploadMultipleFile('complain_image', MAX_IMAGE_SIZE_LIMIT, $complainImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($complainImageDocument['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($complainImageDocument['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($complainImageDocument['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailMultipleUploadFile($complainImageDocument, MEDIA_IMAGE_PATH, THUMBNAIL_MEDIA_IMAGE_PATH);
                }
            }
            $complainData = $this->complainModel->getComplainData(array(
                'complain_id' => $complainId,
            ));
            $complainImageData = $this->mediaModel->getMediaData(array(
                "media_for" => 'complain',
                "media_for_id" => $complainId,
                'is_multiple' => 1
            ));
            if(!empty($complainData)){
                $complainStatusId = isset($complainData['status_id']) ? $complainData['status_id'] : 0;
                $complainRemarks = isset($complainData['remarks']) ? $complainData['remarks'] :'';
            }
            $statusData = $this->statusModel->getStatusData(array(
                'status_id' => $complainStatusId,
            ));
            if($statusData['is_close']){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => "Complain Already Closed",
                    'data' => null
                ), 404);
            }
            $complainUpdateArray = array();
            $complainHistoryUpdateArray = array();
            $complainUpdateArray = array();
            $complainArray = array(
                'complain_id' => $complainId,
                'status_id' => $statusId,
                'remarks' => $remarks,
                'complainant' => $appType,
                'complainant_id' => $userId,
            );
            if (!empty($complainId)) {
                $complainUpdateData = $this->complainModel->getComplainData(array(
                    'complain_id' => $complainId,
                ));
                $complainUpdateArray = compareArray($complainArray, $complainUpdateData);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $complainInsertData = $this->commonWebserviceModel->insertUpdateRecord($complainArray, 'complain_id', 'tbl_complain', 1, '', array(), $extraData, $complainUpdateArray);
            // printArray($complainData,1);
            $complainHistoryArray = array(
                'complain_history_id' => '',
                'complain_id' => $complainId,
                'status_id' => $complainStatusId,
                'remarks' => $complainRemarks,
                'complainant' => $complainData['complainant'],
                'complainant_id' => $complainData['complainant_id'],
                'created_at' => $complainData['created_at'],
                'created_by' => $complainData['created_by'],
                'updated_at' => $complainData['updated_at'],
                'updated_by' => $complainData['updated_by'],
            );
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $complainHistoryData = $this->commonWebserviceModel->insertUpdate($complainHistoryArray, 'complain_history_id', 'tbl_complain_history', 1,$complainHistoryUpdateArray);
            // printArray("jfg",1);
            $lastComplainHistoryId = $complainHistoryData['lastInsertedId'];
            // printArray($lastComplainHistoryId,1);
           
            if (isset($complainImageDocument) && count($complainImageDocument) > 0) {
                $batchArray = array();
                unset($complainImageDocument['success']);
                foreach ($complainImageDocument as $key => $imageData) {
                    $dataArray = array(
                        'media_id' => '',
                        'media_for_id' => $complainId,
                        'media_for' => 'complain',
                        'media_type' => 'image',
                        'media_file' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                        'created_by' => $userId,
                        'updated_by' => $userId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                    array_push($batchArray, $dataArray);
                }
                $complainExtraDataArray = array();
                $complainExtraDataArray['module_id'] = $complainId;
                $complainExtraDataArray['module'] = 'Complain Media Image';
                $complainExtraDataArray['type'] = 'Complain';
                $complainExtraDataArray['old_data'] = '';
                $complainExtraDataArray['user_id'] = $userId;
                $complainExtraDataArray['society_id'] = $societyId;
                $this->complainModel->batchInsert($batchArray, 'tbl_media', $complainExtraDataArray);
            }
            $mediaIdArray = array();
            if(!empty($complainImageData)){
                $imageBatchArray = array();
                foreach($complainImageData as $complainImageHistory){
                    $mediaIdArray[] = $complainImageHistory['media_id'];
                    $imageHistoryArray = array(
                        'complain_history_image_id' => '',
                        'complain_history_id' => $lastComplainHistoryId,
                        'complain_id' => $complainImageHistory['media_for_id'],
                        'complain_image' => $complainImageHistory['media_file'],
                        'media_type' => $complainImageHistory['media_type'],
                        'created_by' => $userId,
                        'updated_by' => $userId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                    array_push($imageBatchArray, $imageHistoryArray);
                }
                // printArray($imageBatchArray,1);
                $this->complainModel->batchInsert($imageBatchArray, 'tbl_complain_history_image');
                $mediaData = $this->complainModel->deleteComplainMediaRecord($mediaIdArray);
            }

            $complainNotificationData = $this->complainModel->getComplainData(array('complain_id'=>$complainId));
            // if($complainNotificationData['is_resolved'] == 1){
                $memberIdArray = array();
                $notificationDataArray = array();
                $notificationMergeArray = array();
                $userDeviceUserIdArray = array();
                $userDeviceUserTypeIdArray = array();
                $userDeviceUserTypeArray = array();
                $userManagerDevice = array();
                $userDeviceManagerIdArray = array();
                $userDeviceManagerTypeIdArray = array();
                $userDeviceManagerTypeArray = array();
                $managementCommitteeData = $this->managementCommitteeModel->getManagementCommitteeData(array(
                    'society_id' => $complainNotificationData['society_id'],
                    'is_api' => 1,
                    'is_multiple' => 1
                ));
                if(!empty($managementCommitteeData)){
                    foreach($managementCommitteeData as $managementCommitteeElement){
                        $memberIdArray[] = $managementCommitteeElement['member_id'];
                    }
                }

                if (!empty($memberIdArray)) {
                    $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => 'Member',
                        'society_id' => $societyId,
                    ));

                    $resourceTypeManagerData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => 'Manager',
                        'society_id' => $societyId,
                    ));

                    if($appType == MANAGER_APP){
                        $resourceTypeIdNot = $resourceTypeManagerData['resource_type_id'];
                    }
                    else{
                        $resourceTypeIdNot = $resourceTypeData['resource_type_id'];
                    }
                    $userSocietyCommitteeData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'society_id' => $societyId,
                        'resource_type_id' => $resourceTypeData['resource_type_id'],
                        'type_id' => $memberIdArray,
                        'resource_type_id_not' => $resourceTypeIdNot,
                        'user_id_not' => $userId,
                        //'is_management_committee' => 1,
                        // 'is_user_device_token_get' => 1,
                        'is_multiple' => 1
                    ));

                    if (!empty($userSocietyCommitteeData)) {
                        foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
                            $userDeviceUserIdArray[] = isset($userSocietyCommitteeElement['user_id']) ? $userSocietyCommitteeElement['user_id'] : 0;
                            $userDeviceUserTypeIdArray[] = isset($userSocietyCommitteeElement['type_id']) ? $userSocietyCommitteeElement['type_id'] : 0;
                            $userDeviceUserTypeArray[] = $resourceTypeData['resource_type_id'];
                        }


                        $userMemberDevice = $this->commonWebserviceModel->deviceData(array(
                            "user_id" => $userDeviceUserIdArray,
                            "user_type_id" => $userDeviceUserTypeIdArray,
                            "resource_type_id" => $userDeviceUserTypeArray,
                            "is_latest" => 1,
                            "is_multiple" => 1
                        ));

                        $userManagerData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'user_id_not' => $userId,
                            'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                            'resource_type_id_not' => $resourceTypeIdNot,
                            'is_multiple' => 1
                        ));

                        if (!empty($userManagerData)) {
                            foreach ($userManagerData as $userManagerCommittee) {
                                $userDeviceManagerIdArray[] = isset($userManagerCommittee['user_id']) ? $userManagerCommittee['user_id'] : 0;
                                $userDeviceManagerTypeIdArray[] = isset($userManagerCommittee['type_id']) ? $userManagerCommittee['type_id'] : 0;
                                $userDeviceManagerTypeArray[] = $resourceTypeManagerData['resource_type_id'];
                            }

                            $userManagerDevice = $this->commonWebserviceModel->deviceData(array(
                                "user_id" => $userDeviceManagerIdArray,
                                "user_type_id" => $userDeviceManagerTypeIdArray,
                                "resource_type_id" => $userDeviceManagerTypeArray,
                                "is_latest" => 1,
                                "is_multiple" => 1
                            ));
                        }

                        $userMergeArray = array_merge($userMemberDevice,$userManagerDevice);
                        if (!empty($userMergeArray)) {
                            foreach ($userMergeArray as $userDeviceElement) {
                                if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['player_id'] != '') {
                                    $notificationArray = array(
                                        'ownership_flat_id' => 0,
                                        'ownership_flat_member_id' => isset($userDeviceElement['type_id']) ? $userDeviceElement['type_id'] : 0,
                                        'type' => 'complain',
                                        'status' => 'complain',
                                        'type_id' => $complainId,
                                        'user_id' => $userId,
                                        'complain_title' => $complainNotificationData['complain_title'],
                                        'complain_number' => $complainNotificationData['complain_number'],
                                        'description' => $complainNotificationData['description'],
                                        'member_name' => $complainNotificationData['complainant_name'],
                                        'society_id' => $societyId,
                                        'notification_title' => 'Complain Status Updated '.$complainNotificationData['complain_number'],
                                        'description' => 'Your complain regarding '.$complainNotificationData['complain_title'].' has been updated. Please check the app for the latest details and status.',
                                        'module' => 'complain',
                                        'action_type' => 'send',
                                        'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                        'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                        'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                        'player_id' => isset($userDeviceElement['player_id']) ? $userDeviceElement['player_id'] : '',
                                        // 'app_url' => MEMBER_URL .'ticket_detail_page/' . $complainId,
                                    );

                                    if ($appType == MANAGER_APP) {
                                        $notificationArray['send_for_notification'] = $appType;
                                        $notificationArray['send_for_notification_id'] = $userId;
                                        $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : '';
                                        $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        // $notificationArray['app_url'] = MANAGER_URL .'ticket_detail_page/' . $complainId ;
                                    }

                                    if ($appType == MEMBER_APP) {
                                        $notificationArray['send_for_notification'] = $appType;
                                        $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                        $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : '';
                                        $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        // $notificationArray['app_url'] = MEMBER_URL .'ticket_detail_page/' . $complainId;
                                    }
                                    $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                    array_push($notificationDataArray, $notificationArray);
                                }
                            }
                        }
                    }

                    if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        sendNotificationComplainAndroid($notificationDataArray);
                    }
                }   
            // }
                
            $complainIdArray = array();
            $complainMediaDataWise = array();
            $complainHistoryDataWise = array();
            $complainHistoryMediaDataWise = array();
            $filterArray = array(
                'is_multiple' => 1,
                'is_active' => 1,
                'complain_id' => $complainId,
            );
            $complainRecordData = $this->complainModel->getComplainData($filterArray);
            $objectFilterData = array(
                'tower_id' => array('tower_id', 'tower_name'),
                'category_id' => array('category_id', 'category_name'),
                'status_id' => array('status_id', 'status_name'),
                'flat_id' => array('flat_id', 'flat_no','tower_flat_name'),
            );
            if (!empty($complainRecordData)) {
                foreach ($complainRecordData as $bkey => $complain) {
                    $complainIdArray[] = $complain['complain_id'];
                }
            }
            if(!empty($complainIdArray)){
                $complainHistoryData = $this->complainModel->getComplainHistoryData(array(
                    'complain_id'=> $complainIdArray,
                    'is_multiple' => 1,
                ));
                if(!empty($complainHistoryData)){
                    foreach($complainHistoryData as $chKey => $complainHistory){
                        $complainHistoryIdArray[] = $complainHistory['complain_history_id'];
                    }
                }
                if(!empty($complainHistoryIdArray)){
                    $complainHistoryMediaData = $this->complainModel->getComplainHistoryImageData(array(
                        "complain_history_id" => $complainHistoryIdArray,
                        "is_multiple" => 1,
                    ));
                    if(!empty($complainHistoryMediaData)) {
                        foreach ($complainHistoryMediaData as $complainHistoryMediaElement) {
                            if ($complainHistoryMediaElement["complain_image"] == '') {
                                $complainHistoryMediaElement["complain_image"] = SITE_URL('uploads/no_image.png');
                                $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL('uploads/no_image.png');
                            } else {
                                if($complainHistoryMediaElement['media_type'] == 'image'){
                                    $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $complainHistoryMediaElement["complain_image"];
                                }
                                else{
                                    $complainHistoryMediaElement["thumbnail_complain_image"] = SITE_URL('uploads/no_image.png');
                                }
                                $complainHistoryMediaElement["complain_image"] = SITE_URL() . MEDIA_IMAGE_PATH . $complainHistoryMediaElement["complain_image"];
                            }
                            $complainHistoryMediaDataWise[$complainHistoryMediaElement['complain_history_id']][] = $complainHistoryMediaElement;
                        }
                    }  
                }
                if(!empty($complainHistoryData)) {
                    foreach ($complainHistoryData as $chKey => $complainHistoryElement) {
                        $complainHistoryData[$chKey]['created_at_display'] = time_elapsed_string($complainHistoryElement['created_at']);
                        $complainHistoryData[$chKey]['updated_at_display'] = time_elapsed_string($complainHistoryElement['updated_at']);
                        $complainHistoryData[$chKey]['complain_history_image_data'] = array_key_exists($complainHistoryElement['complain_history_id'],$complainHistoryMediaDataWise) ? $complainHistoryMediaDataWise[$complainHistoryElement['complain_history_id']]: array();                    
                    }
                }
                if(!empty($complainHistoryData)) {
                    foreach ($complainHistoryData as $complainHistoryElement) {
                        $complainHistoryDataWise[$complainHistoryElement['complain_id']][] = $complainHistoryElement; 
                    }
                }
                $mediaData = $this->complainModel->getMediaData(array(
                    "media_for_id" => $complainIdArray,
                    "media_for" => 'complain',
                    "is_multiple" => 1,
                ));
                if(!empty($mediaData)) {
                    foreach ($mediaData as $mediaElement) {
                        if ($mediaElement["media_file"] == '') {
                            $mediaElement["media_file"] = SITE_URL('uploads/no_image.png');
                            $mediaElement["thumbnail_media_file"] = SITE_URL('uploads/no_image.png');
                        } else {
                            $mediaElement["thumbnail_media_file"] = SITE_URL() . THUMBNAIL_MEDIA_IMAGE_PATH . $mediaElement["media_file"];
                            $mediaElement["media_file"] = SITE_URL() . MEDIA_IMAGE_PATH . $mediaElement["media_file"];
                        }
                        $complainMediaDataWise[$mediaElement['media_for_id']][] = $mediaElement;
                    }
                }
            }
            if (!empty($complainRecordData)) {
                foreach ($complainRecordData as $bkey => $complain) {
                    $complainRecordData[$bkey] = getModuleObjectData($objectFilterData, $complain);
                    $complainRecordData[$bkey]['created_at'] = YMDToDMY($complain["created_at"], true);
                    $complainRecordData[$bkey]['updated_at'] = YMDToDMY($complain["updated_at"], true);
                    $complainRecordData[$bkey]['created_at_display'] = time_elapsed_string($complain['created_at']);
                    $complainRecordData[$bkey]['updated_at_display'] = time_elapsed_string($complain['updated_at']);
                    $complainRecordData[$bkey]['complain_image_data'] = array_key_exists($complain['complain_id'], $complainMediaDataWise) ? $complainMediaDataWise[$complain['complain_id']] : array();
                    $complainRecordData[$bkey]['complain_history_data'] = array_key_exists($complain['complain_id'],$complainHistoryDataWise) ? $complainHistoryDataWise[$complain['complain_id']]: array();
                }
            }
            if (isset($complainId) && !empty($complainId)) {
                if (isset($complainInsertData['success']) && $complainInsertData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.complain')),
                        'data' => $complainRecordData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.complain')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($complainInsertData['success']) && $complainInsertData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.complain')),
                        'data' => $complainRecordData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.complain')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function addEditForum()
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $forumId = $this->request->getVar('forum_id');
        $title = $this->request->getVar('title');
        $description = $this->request->getVar('description');
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $documentImage = $this->request->getVar('document_image[]');
        $documentImageId = $this->request->getVar('document_image_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $appType = $this->request->getVar('app_type');

        $this->validation->setRule('title', lang('CommonWebService.common_title'), 'required');
        $this->validation->setRule('description', lang('CommonWebService.common_description'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $documentImageData = array();
            if (isset($_FILES["document_image"])) {
                $documentImagePath = DOCUMENT_IMAGE_PATH;
                $documentImageData = $dt_ci_file_upload->UploadMultipleFile('document_image', MAX_IMAGE_SIZE_LIMIT, $documentImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($documentImageData['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($documentImageData['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($documentImageData['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailMultipleUploadFile($documentImageData, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
            }

            $forumUpdateArray = array();
            $forumArray = array(
                'forum_id' => $forumId,
                'title' => $title,
                'description' => $description,
                'society_id' => $societyId,
                'type' => 'member',
                'type_id' => $ownershipFlatMemberId,
                'forum_date' => date('Y-m-d'),
                'is_active' => 1,
            );
            if (!empty($forumId)) {
                $forumUpdateArray = $this->commonWebserviceModel->getForumData(array(
                    'forum_id' => $forumId,
                ));
                $forumUpdateArray = compareArray($forumArray, $forumUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $forumData = $this->commonWebserviceModel->insertUpdateRecord($forumArray, 'forum_id', 'tbl_forum', 1, '', array(), $extraData, $forumUpdateArray);
            $lastForumId = $forumData['lastInsertedId'];

            // Forum Multiple Image Store
            if ($lastForumId != '') {
                if (isset($documentImageData) && count($documentImageData) > 0) {
                    $batchArray = array();
                    unset($documentImageData['success']);
                    foreach ($documentImageData as $key => $imageData) {
                        $dataArray = array(
                            'document_image_id' => '',
                            'document_type' => 'forum',
                            'document_type_id' => $lastForumId,
                            'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                            'created_by' => $userId,
                            'updated_by' => $userId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $forumExtraDataArray = array();
                    $forumExtraDataArray['module_id'] = $lastForumId;
                    $forumExtraDataArray['module'] = 'Forum Image';
                    $forumExtraDataArray['type'] = 'Forum';
                    $forumExtraDataArray['old_data'] = '';
                    $forumExtraDataArray['user_id'] = $userId;
                    $forumExtraDataArray['society_id'] = $societyId;
                    $this->commonWebserviceModel->batchInsert($batchArray, 'tbl_document_image', $forumExtraDataArray);
                }
            }

            if (!empty($documentImageId)) {
                $documentImageId = ($documentImageId != '') ? explode(",", $documentImageId) : '';
                if(!empty($documentImageId)){
                    $imageData = $this->visitorModel->getDocumentImageData(array(
                        "document_image_id" => $documentImageId,
                        "is_multiple" => 1
                    ));

                    if(is_array($imageData) && !empty($imageData)){
                        foreach ($imageData as $image){
                            $FileUrl = '';
                            if(isset($image['document_image']) && $image['document_image'] != '') {
                                $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                            }
                            if (file_exists($FileUrl)) {
                                unlink($FileUrl);
                            }
                            $thumbnailFileUrl = '';
                            if(isset($image['document_image']) && $image['document_image'] != '') {
                                $thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
                            }
                            if (file_exists($thumbnailFileUrl)) {
                                unlink($thumbnailFileUrl);
                            }
                        }
                    }
                }
                $documentImageData = $this->commonWebserviceModel->deleteForumImageRecord($documentImageId);
                if ($documentImageData['success']) {
                    if (!empty($documentImageId)) {
                        foreach ($documentImageId as $documentImage) {
                            $deleteDataArray['module'] = 'Forum Image';
                            $deleteDataArray['activity'] = "Forum Image Deleted";
                            $deleteDataArray['module_id'] = $documentImage;
                            logActivity('Forum Image Deleted [ForumImageID: ' . $documentImage . ']', $userId, 'Forum', $documentImage, json_encode($deleteDataArray), '', 'Forum Image', $documentImage);
                        }
                    }
                }
            }

            if ($forumId == '') {
                $userIdArray = array();
                $customerDataArray = array();
                $batchNotificationDataArray = array();
                $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                    'resource_type_name' => 'Member',
                    'society_id' => $societyId,
                ));
                $notificationArray = array(
                    'notification_title' => 'New Forum Published',
                    'description' => 'A new Forum titled '.$title.' has been published by the management. Please check the app to read the full details.',
                );
                $playerIdArray = array();
                $iosPlayerIdArray = array();
                $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'society_id' => $societyId,
                    'user_id_not' => $userId,
                    'resource_type_id' => $resourceTypeData['resource_type_id'],
                    'resource_type_id_not' => $resourceTypeData['resource_type_id'],
                    'is_multiple' => 1
                ));
                if(!empty($userSocietyData)){
                    foreach($userSocietyData as $userSocietyElement){
                        $userIdArray[] = $userSocietyElement['user_id'];
                    }
                }
                if(!empty($userIdArray)){
                    $userDeviceArray = $this->commonWebserviceModel->deviceData(array(
                        "user_id" => $userIdArray,
                        "resource_type_id" => $resourceTypeData['resource_type_id'],
                        "is_latest" => 1,
                        "is_multiple" => 1,
                    ));
                }
                if(!empty($userDeviceArray)){
                    foreach($userDeviceArray as $userDevice){
                        $memberArray = $this->commonWebserviceModel->getUserSocietyData(array(
                            'user_id' => $userDevice['user_id'],
                            'society_id' => $societyId,
                            'resource_type_id' => $resourceTypeData['resource_type_id'],
                        ));
                        $notificationOtherArray = array(
                            'notification_id' => '',
                            'society_id' => $societyId,
                            'notification_date' => TODAY_DATE_YMD,
                            'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                            'type' => 'forum',
                            'type_id' => $lastForumId,
                            // 'module' => 'poll',
                            'created_by' => $userId,
                            'updated_by' => $userId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        $notificationOtherArray['send_for_notification'] = $appType;
                        $notificationOtherArray['send_for_notification_id'] = $userId;
                        $notificationOtherArray['receive_for_notification'] = $resourceTypeData['resource_type_id'];
                        $notificationOtherArray['receive_for_notification_id'] = $memberArray['type_id'];
                        if(!empty($notificationArray)){
                            $notificationArray = array_merge($notificationArray,$notificationOtherArray);
                            $extraDataJsonArray = $notificationArray;
                            $extraDataJsonArray['module'] = 'forum';
                            $extraDatajson = json_encode($extraDataJsonArray);
                            $notificationArray['extra_data'] = $extraDatajson;
                            $customerData['extra_data'] = $extraDatajson;
                            //send notification data
                            $deviceToken = $userDevice['one_signal_id'];
                            $playerId = $userDevice['player_id'];
                            $batchNotificationDataArray[] = $notificationArray;
                            if(strtolower($userDevice['device_type']) == 'android'){
                                if (!empty($playerId)) {
                                    array_push($playerIdArray,$playerId);
                                }
                            } else {
                                if (!empty($playerId)) {
                                    array_push($iosPlayerIdArray,$playerId);
                                }
                            }
                        }
                    }
                }
                if(!empty($batchNotificationDataArray)){
                    $this->commonWebserviceModel->batchInsert($batchNotificationDataArray,'tbl_notification');
                }
                $sendNotificationData = array();
                if(!empty($playerIdArray)){
                    $customerData['player_id'] = $playerIdArray;
                    $customerData['app_url'] = MEMBER_URL .'forum_detail/' . $lastForumId;
                    $sendNotificationData = $customerData;
                    sendNotificationAndroid($sendNotificationData);
                }
                $sendNotificationIOSData = array();
                if(!empty($iosPlayerIdArray)){
                    $customerData['player_id'] = $iosPlayerIdArray;
                    $sendNotificationIOSData = $customerData;
                    sendNotificationIOS($sendNotificationIOSData);
                }
            }
            $forumFilterArray = array(
                'forum_id' => $lastForumId,
            );
            $forumInsertData = $this->commonWebserviceModel->getForumData($forumFilterArray);
            $forumDocumentDataWise = array();
            if (!empty($forumInsertData)) {
                $forumImageData = $this->visitorModel->getDocumentImageData(array(
                    "document_type_id" => $lastForumId,
                    "document_type" => 'forum',
                    "is_multiple" => 1
                ));

                if (!empty($forumImageData)) {
                    foreach ($forumImageData as $forumImageElement) {
                        if ($forumImageElement["document_image"] == '') {
                            $forumImageElement["thumbnail_document_image"] = SITE_URL('uploads/no_image.png');
                            $forumImageElement["document_image"] = SITE_URL('uploads/no_image.png');
                        } else {
                            $forumImageElement["thumbnail_document_image"] = SITE_URL() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $forumImageElement["document_image"];
                            $forumImageElement["document_image"] = SITE_URL() . DOCUMENT_IMAGE_PATH . $forumImageElement["document_image"];
                        }
                        $forumDocumentDataWise[$forumImageElement['document_type_id']][] = $forumImageElement;
                    }
                }   
            }
            if (!empty($forumInsertData)) {
                if (($forumInsertData['type_id'] == $ownershipFlatMemberId) && ($forumInsertData['type'] == 'member')) {
                    $forumInsertData['is_editable'] = 1;
                } else {
                    $forumInsertData['is_editable'] = 0;
                }
                $forumInsertData['forum_date'] = YMDToDMY($forumInsertData["forum_date"]);
                $forumInsertData['created_at'] = YMDToDMY($forumInsertData["created_at"], true);
                $forumInsertData['updated_at'] = YMDToDMY($forumInsertData["updated_at"], true);
                $forumInsertData['created_at_display'] = time_elapsed_string($forumInsertData['created_at']);
                $forumInsertData['updated_at_display'] = time_elapsed_string($forumInsertData['created_at']);
                $path = site_url('uploads/no_image.png');
                $thumbnailPath = site_url('uploads/no_image.png');

                if($forumInsertData['type'] == 'member'){
                    if ($forumInsertData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $forumInsertData['member_image'])) {
                        $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $forumInsertData['member_image'];
                    }
                    if ($forumInsertData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $forumInsertData['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $forumInsertData['member_image'];
                    }
                }

                if($forumInsertData['type'] == 'admin'){
                    if ($forumInsertData['member_image'] != '' && file_exists(USER_IMAGE_PATH . $forumInsertData['member_image'])) {
                        $path = site_url() . USER_IMAGE_PATH . $forumInsertData['member_image'];
                    }
                    if ($forumInsertData['member_image'] != '' && file_exists(THUMBNAIL_USER_IMAGE_PATH . $forumInsertData['member_image'])) {
                        $thumbnailPath = site_url() . THUMBNAIL_USER_IMAGE_PATH . $forumInsertData['member_image'];
                    }
                }

                $forumInsertData['member_image'] = $path;
                $forumInsertData['thumbnail_member_image'] = $thumbnailPath;

                $shareData = array(
                    'share_title' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industrys',
                    'share_description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                    'share_image' => base_url('uploads/no_image.png'),
                    "share_link" => "https://digitattva.in/",
                );
                $forumInsertData['share_data'] = $shareData;
                $forumInsertData['forum_image_data'] = array_key_exists($forumInsertData['forum_id'], $forumDocumentDataWise) ? $forumDocumentDataWise[$forumInsertData['forum_id']] : array();
            }
            if (isset($forumId) && !empty($forumId)) {
                if (isset($forumData['success']) && $forumData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.forum')),
                        'data' => $forumInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.forum')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($forumData['success']) && $forumData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.forum')),
                        'data' => $forumInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.forum')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }



    

    public function SosEmergencyResolved() // not
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $sosEmergencyId = $this->request->getVar('sos_emergency_id');
        $userId = $this->request->getVar('user_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $societyId = $this->request->getVar('society_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('sos_emergency_id', lang('CommonWebService.sos_emergency_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $statusId = 0;
            $statusData = $this->statusModel->getStatusData(array(
                'is_resolved' => 1,
                'status_for' => 'sos_emergency',
                'is_active' => 1,
            ));
            if (empty($statusData)) {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => 'Status Master Sos Emergency Is Resolved Status Not Defined',
                    'data' => null
                ), 404);
            }
            if (!empty($statusData)) {
                $statusId = isset($statusData['status_id']) ? $statusData['status_id'] : 0;
            }
            $sosEmergecyUpdateArray = array();
            $sosEmergencyArray = array(
                'sos_emergency_id' => $sosEmergencyId,
                'status_id' => $statusId,
            );
            if (!empty($sosEmergencyId)) {
                $sosEmergecyUpdateArray = $this->sosModel->getSosEmergencyData(array(
                    'sos_emergency_id' => $sosEmergencyId,
                ));
                $sosEmergecyUpdateArray = compareArray($sosEmergencyArray, $sosEmergecyUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $sosEmergencyData = $this->commonWebserviceModel->insertUpdateRecord($sosEmergencyArray, 'sos_emergency_id', 'tbl_sos_emergency', 1, '', array(), $extraData, $sosEmergecyUpdateArray);
            $lastSosEmergencyId = $sosEmergencyData['lastInsertedId'];

            $notificationSosEmergencyArrayData = array();
            $notificationSosEmergencyData = $this->notificationModel->getNotificationData(array(
                'type' => 'sos_emergency',
                'type_id' => $sosEmergencyId,
                'is_multiple' => 1,
            ));

            // printArray($notificationSosEmergencyData,1);

            if(!empty($notificationSosEmergencyData)){
                foreach($notificationSosEmergencyData as $notificationElement){
                    $notificationSosEmergencyArrayData[] = array(
                        'notification_id' => $notificationElement['notification_id'],
                        'is_resolved' => 1,
                        'updated_by' => $userId,
                        'updated_at' => date("Y-m-d H:i:s")
                    );
                }
            }

            if(!empty($notificationSosEmergencyArrayData)){
                $this->notificationModel->batchUpdate($notificationSosEmergencyArrayData, 'notification_id', 'tbl_notification');
            }
            $sosNotification = $this->sosModel->getSosEmergencyNotificationData(array(
                'sos_emergency_id' => $sosEmergencyId,
                'is_multiple' => 1
            ));
            $notificationDataArray = array();
            $memberIdArray = array();
            $ownershipFlatIdArray = array();
            $sosEmergecyInsertData = $this->sosModel->getSosEmergencyData(array(
                'sos_emergency_id' => $lastSosEmergencyId,
            ));
            if (!empty($sosNotification)) {
                $sosNotificationTypeArray = array();
                foreach ($sosNotification as $sosNotificationElement) {
                    $resourceTypeMemberData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => 'Member',
                        'society_id' => $societyId,
                    ));
                    $resourceTypeManagerData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => 'Manager',
                        'society_id' => $societyId,
                    ));
                    $resourceTypeGuardData = $this->resource_type_model->getResourceTypeData(array(
                        'is_guard' => 1,
                        'is_multiple' => 1,
                        'is_login' => 1,
                        'is_active' => 1,
                        'society_id' => $societyId,
                    ));
                    $resourceTypeIdArray = [];
                    if (!empty($resourceTypeGuardData)) {
                        foreach ($resourceTypeGuardData as $resourceTypeElement) {
                            $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                        }
                    }
                    $userData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'id' => $userId,
                    ));
                    $resourceTypeIdNot = $userData['resource_type_id'];
                    if ($sosNotificationElement['sos_emergency_type'] == 'family') {
                        $ownershipFlatMemberIdArray = array();
                        $userDeviceUserIdArray = array();
                        $userDeviceUserTypeIdArray = array();
                        $userDeviceUserTypeArray = array();
                        $userMergeArray = array();

                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'is_show_all_member' => 1,
                            'is_active' => 1
                        ));
                        if (!empty($ownershipFlatMemberData)) {
                            $type = isset($ownershipFlatMemberData['type']) ? $ownershipFlatMemberData['type'] : '';
                            if ($type == 'ownership_flat') {
                                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                    'ownership_flat_id' => $ownershipFlatMemberData['ownership_flat_id'],
                                    'ownership_flat_member_id_not' => $ownershipFlatMemberId,
                                    'type' => $type,
                                    'is_show_all_member' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1
                                ));
                            } else if ($type == 'rentals') {
                                $ownershipFlatData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                    'ownership_flat_id' => $ownershipFlatMemberData['ownership_flat_id'],
                                    'ownership_flat_member_id_not' => $ownershipFlatMemberId,
                                    'is_show_all_member' => 1,
                                    'is_multiple' => 1,
                                    'is_active' => 1
                                ));
                            }
                        }
                        if (!empty($ownershipFlatData)) {
                            foreach ($ownershipFlatData as $ownershipFlat) {
                                $ownershipFlatMemberIdArray[] = $ownershipFlat['ownership_flat_member_id'];
                            }
                        }
                        if (!empty($ownershipFlatMemberIdArray)) {
                            $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                                'society_id' => $societyId,
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $ownershipFlatMemberIdArray,
                                'is_multiple' => 1
                            ));

                            if (!empty($userSocietyFamilyData)) {
                                foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                    $userDeviceUserIdArray[] = isset($userSocietyFamilyElement['user_id']) ? $userSocietyFamilyElement['user_id'] : 0;
                                    $userDeviceUserTypeIdArray[] = isset($userSocietyFamilyElement['type_id']) ? $userSocietyFamilyElement['type_id'] : 0;
                                    $userDeviceUserTypeArray[] = $resourceTypeMemberData['resource_type_id'];
                                }
                                $userDevice = $this->commonWebserviceModel->deviceData(array(
                                    "user_id" => $userDeviceUserIdArray,
                                    "user_type_id" => $userDeviceUserTypeIdArray,
                                    "resource_type_id" => $userDeviceUserTypeArray,
                                    "is_latest" => 1,
                                    "is_multiple" => 1
                                ));


                                if (!empty($userDevice)) {
                                    foreach ($userDevice as $userDeviceElement) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['player_id'] != '') {
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'type' => 'sos_emergency_resolved',
                                                'status' => 'sos_emergency_resolved',
                                                'type_id' => $lastSosEmergencyId,
                                                'society_id' => $societyId,
                                                'flat_id' => 0,
                                                'staff_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'management_committee_id' => 0,
                                                //'user_id' => isset($staff['user_id']) ? $staff['user_id'] : 0,
                                                'user_id' => $userId,
                                                'category_name' => $sosEmergecyInsertData['category_name'],
                                                'notification_title' => $sosEmergecyInsertData['category_name'] . ' Resolved',
                                                'description' => 'The SOS alert with the topic ' . $sosEmergecyInsertData['category_name'] . ' has been resolved. Thank you for your prompt attention.',
                                                'module' => 'sos_emergency',
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'player_id' => isset($userDeviceElement['player_id']) ? $userDeviceElement['player_id'] : '',
                                                'app_type' => $appType,
                                                // 'app_url' => MEMBER_URL .'sos_alert/' . $lastSosEmergencyId,
                                                // 'user_type_name' => isset($userDeviceElement['user_type_name']) ? $userDeviceElement['user_type_name'] : '',
                                                // 'display_status' => underscoreToUcWord('sos_emergency_resolved'),
                                            );
                                            if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : 0;
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MANAGER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : '';
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MEMBER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : 0;
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }
                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }
                        // if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        //     sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                        // }

                    } else if ($sosNotificationElement['sos_emergency_type'] == 'resident') {
                        $ownershipFlatMemberIdArray = array();
                        $userDeviceUserIdArray = array();
                        $userDeviceUserTypeIdArray = array();
                        $userDeviceUserTypeArray = array();
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'society_id' => $societyId,
                            'ownership_flat_member_id_not' => $ownershipFlatMemberId,
                            'is_latest' => 1,
                            'is_show_all_member' => 1,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));
                        if (!empty($ownershipFlatMemberData)) {
                            foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                $ownershipFlatMemberIdArray[] = $ownershipFlatMember['ownership_flat_member_id'];
                            }
                        }
                        $notificationDataArray = array();
                        if (!empty($ownershipFlatMemberIdArray)) {

                            $userSocietyFamilyData = $this->commonWebserviceModel->getUserSocietyData(array(
                                'society_id' => $societyId,
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $ownershipFlatMemberIdArray,
                                'is_multiple' => 1
                            ));

                            if (!empty($userSocietyFamilyData)) {
                                foreach ($userSocietyFamilyData as $userSocietyFamilyElement) {
                                    $userDeviceUserIdArray[] = isset($userSocietyFamilyElement['user_id']) ? $userSocietyFamilyElement['user_id'] : 0;
                                    $userDeviceUserTypeIdArray[] = isset($userSocietyFamilyElement['type_id']) ? $userSocietyFamilyElement['type_id'] : 0;
                                    $userDeviceUserTypeArray[] = $resourceTypeMemberData['resource_type_id'];
                                }
                                $userDevice = $this->commonWebserviceModel->deviceData(array(
                                    "user_id" => $userDeviceUserIdArray,
                                    "user_type_id" => $userDeviceUserTypeIdArray,
                                    "resource_type_id" => $userDeviceUserTypeArray,
                                    "is_latest" => 1,
                                    "is_multiple" => 1
                                ));

                                if (!empty($userDevice)) {
                                    foreach ($userDevice as $userDeviceElement) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['player_id'] != '') {
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'type' => 'sos_emergency_resolved',
                                                'status' => 'sos_emergency_resolved',
                                                'type_id' => $lastSosEmergencyId,
                                                'society_id' => $societyId,
                                                'flat_id' => 0,
                                                'staff_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                                'management_committee_id' => 0,
                                                //'user_id' => isset($staff['user_id']) ? $staff['user_id'] : 0,
                                                'user_id' => $userId,
                                                'category_name' => $sosEmergecyInsertData['category_name'],
                                                'notification_title' => $sosEmergecyInsertData['category_name'] . ' Resolved',
                                                'description' => 'The SOS alert with the topic ' . $sosEmergecyInsertData['category_name'] . ' has been resolved. Thank you for your prompt attention.',
                                                'module' => 'sos_emergency',
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'player_id' => isset($userDeviceElement['player_id']) ? $userDeviceElement['player_id'] : '',
                                                'app_type' => $appType,
                                                // 'app_url' => MEMBER_URL .'sos_alert/' . $lastSosEmergencyId,
                                                // 'user_type_name' => isset($userDeviceElement['user_type_name']) ? $userDeviceElement['user_type_name'] : '',
                                                // 'display_status' => underscoreToUcWord('sos_emergency_resolved'),
                                            );
                                            if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : 0;
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MANAGER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : '';
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MEMBER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : 0;
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }
                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }
                        // if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        //     sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                        // }

                    } else if ($sosNotificationElement['sos_emergency_type'] == 'committee') {
                        $userDeviceUserIdArray = array();
                        $userDeviceUserTypeIdArray = array();
                        $userDeviceUserTypeArray = array();
                        $notificationDataArray = array();
                        $userManagerDevice = array();
                        $userDeviceManagerIdArray = array();
                        $userDeviceManagerTypeIdArray = array();
                        $userDeviceManagerTypeArray = array();

                        $managementCommitteeData = $this->managementCommitteeModel->getManagementCommitteeData(array(
                            'society_id' => $societyId,
                            'is_api' => 1,
                            'is_multiple' => 1
                        ));
                        if (!empty($managementCommitteeData)) {
                            foreach ($managementCommitteeData as $managementCommitteeElement) {
                                $memberIdArray[] = $managementCommitteeElement['member_id'];
                            }
                        }
                        if (!empty($memberIdArray)) {
                            $userSocietyCommitteeData = $this->commonWebserviceModel->getUserSocietyData(array(
                                'society_id' => $societyId,
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $memberIdArray,
                                'resource_type_id_not' => $resourceTypeIdNot,
                                'user_id_not' => $userId,
                                //'is_management_committee' => 1,
                                //'is_user_device_token_get' => 1,
                                'is_multiple' => 1
                            ));

                            if (!empty($userSocietyCommitteeData)) {
                                foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
                                    $userDeviceUserIdArray[] = isset($userSocietyCommitteeElement['user_id']) ? $userSocietyCommitteeElement['user_id'] : 0;
                                    $userDeviceUserTypeIdArray[] = isset($userSocietyCommitteeElement['type_id']) ? $userSocietyCommitteeElement['type_id'] : 0;
                                    $userDeviceUserTypeArray[] = $resourceTypeMemberData['resource_type_id'];
                                }
                                
                                $userMemberDevice = $this->commonWebserviceModel->deviceData(array(
                                    "user_id" => $userDeviceUserIdArray,
                                    "user_type_id" => $userDeviceUserTypeIdArray,
                                    "resource_type_id" => $userDeviceUserTypeArray,
                                    "is_latest" => 1,
                                    "is_multiple" => 1
                                ));

                                $userManagerData = $this->commonWebserviceModel->getUserSocietyData(array(
                                    'society_id' => $societyId,
                                    'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                                    'resource_type_id_not' => $resourceTypeIdNot,
                                    'user_id_not' => $userId,
                                    'is_multiple' => 1
                                ));

                                if (!empty($userManagerData)) {
                                    foreach ($userManagerData as $userManagerCommittee) {
                                        $userDeviceManagerIdArray[] = isset($userManagerCommittee['user_id']) ? $userManagerCommittee['user_id'] : 0;
                                        $userDeviceManagerTypeIdArray[] = isset($userManagerCommittee['type_id']) ? $userManagerCommittee['type_id'] : 0;
                                        $userDeviceManagerTypeArray[] = $resourceTypeManagerData['resource_type_id'];
                                    }

                                    $userManagerDevice = $this->commonWebserviceModel->deviceData(array(
                                        "user_id" => $userDeviceManagerIdArray,
                                        "user_type_id" => $userDeviceManagerTypeIdArray,
                                        "resource_type_id" => $userDeviceManagerTypeArray,
                                        "is_latest" => 1,
                                        "is_multiple" => 1
                                    ));
                                }

                                $userMergeArray = array_merge($userMemberDevice,$userManagerDevice);

                                if (!empty($userMergeArray)) {
                                    foreach ($userMergeArray as $userDeviceElement) {
                                        if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['player_id'] != '') {
                                            $notificationArray = array(
                                                'ownership_flat_id' => 0,
                                                'ownership_flat_member_id' => isset($userDeviceElement['type_id']) ? $userDeviceElement['type_id'] : 0,
                                                'type' => 'sos_emergency_resolved',
                                                'status' => 'sos_emergency_resolved',
                                                'type_id' => $lastSosEmergencyId,
                                                'society_id' => $societyId,
                                                'flat_id' => 0,
                                                'staff_id' => isset($userDeviceElement['type_id']) ? $userDeviceElement['type_id'] : 0,
                                                'management_committee_id' => isset($userDeviceElement['management_committee_id']) ? $userDeviceElement['management_committee_id'] : 0,
                                                //'user_id' => isset($staff['user_id']) ? $staff['user_id'] : 0,
                                                'user_id' => $userId,
                                                'category_name' => $sosEmergecyInsertData['category_name'],
                                                'notification_title' => $sosEmergecyInsertData['category_name'] . ' Resolved',
                                                'description' => 'The SOS alert with the topic ' . $sosEmergecyInsertData['category_name'] . ' has been resolved. Thank you for your prompt attention.',
                                                'module' => 'sos_emergency',
                                                'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                                'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                                'player_id' => isset($userDeviceElement['player_id']) ? $userDeviceElement['player_id'] : '',
                                                'app_type' => $appType,
                                                // 'app_url' => MEMBER_URL .'sos_alert/' . $lastSosEmergencyId,
                                                // 'user_type_name' => isset($userDeviceElement['user_type_name']) ? $userDeviceElement['user_type_name'] : '',
                                                // 'display_status' => underscoreToUcWord('sos_emergency_resolved'),
                                            );

                                            if ($appType == GATE_KEEPER) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : '';
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MANAGER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $userId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : '';
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }

                                            if ($appType == MEMBER_APP) {
                                                $notificationArray['send_for_notification'] = $appType;
                                                $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                                $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : '';
                                                $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                            }
                                            $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                            array_push($notificationDataArray, $notificationArray);
                                        }
                                    }
                                }
                            }
                        }
                        // if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        //     sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                        // }

                    } else if ($sosNotificationElement['sos_emergency_type'] == 'gatekeeper') {
                        $resourceTypeData = $this->resourceTypeModel->getResourceTypeData(array(
                            'is_guard' => 1,
                            'is_login' => 1,
                            'is_active' => 1,
                            'is_multiple' => 1,
                        ));
                        $resourceTypeIdArray = [];
                        if (!empty($resourceTypeData)) {
                            foreach ($resourceTypeData as $resourceTypeElement) {
                                $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                            }
                        }
                        $userDeviceUserIdArray = [];
                        $userDeviceUserTypeIdArray = [];
                        $userDeviceUserTypeArray = [];
                        $userSocietyStaffData = $this->commonWebserviceModel->getUserSocietyData(array(
                            'society_id' => $societyId,
                            'resource_type_id' => $resourceTypeIdArray,
                            'resource_type_id_not' => $resourceTypeIdNot,
                            'user_id_not' => $userId,
                            // 'is_user_device_token_get' => 1,
                            'is_multiple' => 1
                        ));

                        if (!empty($userSocietyStaffData)) {
                            foreach ($userSocietyStaffData as $userSocietyStaffElement) {
                                $userDeviceUserIdArray[] = isset($userSocietyStaffElement['user_id']) ? $userSocietyStaffElement['user_id'] : 0;
                                $userDeviceUserTypeIdArray[] = isset($userSocietyStaffElement['type_id']) ? $userSocietyStaffElement['type_id'] : 0;
                                $userDeviceUserTypeArray[] = isset($userSocietyStaffElement['resource_type_id']) ? $userSocietyStaffElement['resource_type_id'] : 0;;
                            }

                            $userDevice = $this->commonWebserviceModel->deviceData(array(
                                "user_id" => $userDeviceUserIdArray,
                                "user_type_id" => $userDeviceUserTypeIdArray,
                                "resource_type_id" => $userDeviceUserTypeArray,
                                "is_latest" => 1,
                                "is_multiple" => 1
                            ));

                            // printArray($userDevice,1);

                            if (!empty($userDevice)) {
                                foreach ($userDevice as $userDeviceElement) {
                                    if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['player_id'] != '') {
                                        $notificationArray = array(
                                            'ownership_flat_id' => 0,
                                            'ownership_flat_member_id' => 0,
                                            'type' => 'sos_emergency_resolved',
                                            'status' => 'sos_emergency_resolved',
                                            'type_id' => $lastSosEmergencyId,
                                            'society_id' => $societyId,
                                            'flat_id' => 0,
                                            'staff_id' => isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0,
                                            'management_committee_id' => 0,
                                            //'user_id' => isset($staff['user_id']) ? $staff['user_id'] : 0,
                                            'user_id' => $userId,
                                            'category_name' => $sosEmergecyInsertData['category_name'],
                                            'notification_title' => $sosEmergecyInsertData['category_name'] . ' Resolved',
                                            'description' => 'The SOS alert with the topic ' . $sosEmergecyInsertData['category_name'] . ' has been resolved. Thank you for your prompt attention.',
                                            'module' => 'sos_emergency',
                                            'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                            'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
                                            'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
                                            'player_id' => isset($userDeviceElement['player_id']) ? $userDeviceElement['player_id'] : '',
                                            'app_type' => $appType,
                                            // 'app_url' => GATE_KEEPER_URL .'sos_send_message/' . $lastSosEmergencyId,
                                            // 'user_type_name' => isset($userDeviceElement['user_type_name']) ? $userDeviceElement['user_type_name'] : '',    
                                            // 'display_status' => underscoreToUcWord('sos_emergency_resolved'),
                                        );

                                        if ($appType == GATE_KEEPER) {
                                            $notificationArray['send_for_notification'] = $appType;
                                            $notificationArray['send_for_notification_id'] = $userId;
                                            $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : 0;
                                            $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        }

                                        if ($appType == MANAGER_APP) {
                                            $notificationArray['send_for_notification'] = $appType;
                                            $notificationArray['send_for_notification_id'] = $userId;
                                            $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : 0;
                                            $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        }

                                        if ($appType == MEMBER_APP) {
                                            $notificationArray['send_for_notification'] = $appType;
                                            $notificationArray['send_for_notification_id'] = $ownershipFlatMemberId;
                                            $notificationArray['receive_for_notification'] = isset($userDeviceElement['resource_type_id']) ? $userDeviceElement['resource_type_id'] : 0;
                                            $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
                                        }
                                        $notificationArray['extra_data_json'] = json_encode($notificationArray);
                                        array_push($notificationDataArray, $notificationArray);
                                    }
                                }
                            }
                        }
                        // if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                        //     sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                        // }
                    }
                }
                if (isset($notificationDataArray) && !empty($notificationDataArray)) {
                    sendNotificationSosGateKeeperAndroid($notificationDataArray,$lastSosEmergencyId);
                }
            }

            if (isset($sosEmergencyData['success']) && $sosEmergencyData['success']) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.sos_emergency_resolved_successfully'),
                    'data' => null
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.sos_emergency_resolved_unsuccessfully'),
                    'data' => null
                ), 400);
            }
        }
    }

    public function userLogin()// not
    {
        $mobileNo = $this->request->getVar('mobile_no');
        $deviceId = $this->request->getVar('device_id');
        $appType = $this->request->getVar('app_type');
        $latitude = $this->request->getVar('latitude');
        $longitude = $this->request->getVar('longitude');
        $this->validation->setRule('mobile_no', lang('CommonWebService.mobile_no'), 'required|max_length[10]|min_length[10]');
        $this->validation->setRule('device_id', lang('CommonWebService.device_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $userData = array();
            $userData = $this->commonWebserviceModel->getUserSocietyData(array(
                'phone' => $mobileNo,
            ));

            $permissionsArray = array();
            if($appType == MEMBER_APP){
                $permissionsToCheck = customerAppPermission();
            }

            if($appType == GATE_KEEPER){
                $permissionsToCheck = gatekeeperAppPermission();
            }

            if($appType == MANAGER_APP){
                $permissionsToCheck = managerAppPermission();
            }

            $password = PASSWORD;


            if (empty($userData)) {
                return $this->response(array(
                    'status' => FALSE,
                    'message' => lang('CommonWebService.kindly_contact_society_admin'),
                    'data' => null,
                    'response_code' => 200
                ), 200);
            }

            if ($appType == MEMBER_APP) {
                $ownershipFlatIdArray = array();
                $societyIdArray = array();
                $userSocietyIdArray = array();
                $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'mobile_no' => $mobileNo,
                ));
                $ownershipFlatMemberFoundData = array();
                $rentalMemberFoundData = array();
                $moduleType = '';
                if (!empty($flatMemberFoundData)) {
                    $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                    $ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                    if ($moduleType == 'ownership_flat') {
                        $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'mobile_no' => $mobileNo,
                            'is_latest' => 1,
                            'is_active' => 1
                        ));

                        $flatOwnershipIdArray = array();
                        $userOwnershipIdArray = array();
                        if (!empty($ownershipFlatMemberFoundData)) {
                            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'mobile_no' => $mobileNo,
                                'is_latest' => 1,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                            //printArray($ownershipFlatMemberData,1);
                            if (!empty($ownershipFlatMemberData)) {
                                foreach ($ownershipFlatMemberData as $ownershipFlatMemberElement) {
                                    $societyIdArray[] = $ownershipFlatMemberElement['society_id'];
                                    $flatOwnershipIdArray[] = $ownershipFlatMemberElement['ownership_flat_member_id'];
                                }
                                $societyIdArray = array_unique($societyIdArray);
                                if (!empty($userData)) {
                                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                                        'user_id' => $userData['id'],
                                        'type' => MEMBER_APP,
                                        'is_multiple' => 1
                                    ));

                                    if (!empty($userSocietyData)) {
                                        foreach ($userSocietyData as $userSocietyElement) {
                                            $userSocietyIdArray[] = $userSocietyElement['society_id'];
                                            $userOwnershipIdArray[] = $userSocietyElement['type_id'];
                                        }
                                    }
                                    $userSocietyIdArray = array_unique($userSocietyIdArray);
                                }



                                $userSocietyOwnerMemberDifferenceArray = array_diff($flatOwnershipIdArray, $userOwnershipIdArray);

                                $societyDifferenceArray = array_diff($societyIdArray, $userSocietyIdArray);
                                $lastUserId = $userData['id'];

                                
                            }
                        }
                    } else if ($moduleType == 'rentals') {
                        $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'check_rental_start' => 1,
                            'is_active' => 1
                        ));

                        if (!empty($rentalMemberFoundData)) {
                            $rentalMemberData = $this->rentalModel->getRentalsMemberData(array(
                                'ownership_flat_member_id' => $ownershipFlatMemberId,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                        }
                        $rentalsIdArray = array();
                        $societyIdArray = array();
                        //printArray($rentalMemberData,1);
                        if (!empty($rentalMemberData)) {
                            foreach ($rentalMemberData as $rentalMemberElement) {
                                $rentalsIdArray[] = $rentalMemberElement['type_id'];
                            }

                            if (!empty($rentalsIdArray)) {
                                $rentalsData = $this->rentalModel->getRentalsData(array(
                                    'is_api_call' => 1,
                                    'rentals_id' => $rentalsIdArray,
                                    'is_multiple' => 1
                                ));

                                if (!empty($rentalsData)) {
                                    foreach ($rentalsData as $rentalsElement) {
                                        $societyIdArray[] = $rentalsElement['society_id'];
                                    }
                                }
                                $societyIdArray = array_unique($societyIdArray);

                                if (!empty($userData)) {
                                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                                        'user_id' => $userData['id'],
                                        'type' => MEMBER_APP,
                                        'is_multiple' => 1
                                    ));
                                    if (!empty($userSocietyData)) {
                                        foreach ($userSocietyData as $userSocietyElement) {
                                            $userSocietyIdArray[] = $userSocietyElement['society_id'];
                                        }
                                    }
                                    $userSocietyIdArray = array_unique($userSocietyIdArray);
                                }

                                $societyDifferenceArray = array_diff($societyIdArray, $userSocietyIdArray);
                                $lastUserId = $userData['id'];
                            }
                        }
                    }
                }
                if ((empty($ownershipFlatMemberData)) && empty($rentalMemberFoundData)) {
                    return $this->response(array(
                        'status' => FALSE,
                        'message' => lang('CommonWebService.kindly_contact_society_admin'),
                        'data' => null,
                        'response_code' => 200
                    ), 200);
                }
            }
            $deviceUserType = '';
            if ($appType == GATE_KEEPER) {
                $deviceUserType = GATE_KEEPER;
            }
            else if ($appType == MANAGER_APP) {
                $deviceUserType = MANAGER_APP;
            }
            else {
                $deviceUserType = MEMBER_APP;
            }
            $userDataFilter = array();
            if (!empty($userData)) {
                if (isset($userData['active']) && $userData['active'] != 1) {
                    //return $this->respond(array(
                    return $this->response(array(
                        'status' => FALSE,
                        'message' => lang('CommonWebService.user_account_is_inactive'),
                        'data' => null,
                        'response_code' => 200
                    ), 200);
                }
                $userId = $userData['id'];
            }
            if ($appType == MEMBER_APP) {
                $userData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'phone' => $mobileNo
                ));
                $otp = OTP_CODE;
                if (DEV_ENVIRONMENT == 'production') {
                    if (isset($userData['phone']) && $userData['phone'] == '8976677224') {
                        $otp = OTP_CODE;
                    } else {
                        $otp = GenRandomNumber(6);
                    }
                }
                $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                $userArray['otp'] = $otp;
                $userArray['otp_validity'] = $otpValidity;
                $this->commonWebserviceModel->updateData($userArray, 'tbl_users', 'id', $userData['id']);
                $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                    'phone' => $mobileNo
                ));
                if (!empty($userDataFilter)) {
                    if (empty($userDataFilter['password'])) {
                        $userDataFilter['is_password_empty'] = 1;
                    } else {
                        $userDataFilter['is_password_empty'] = 0;
                    }
                }
            }

            if ($appType == GATE_KEEPER) {
                $otp = OTP_CODE;
                if (DEV_ENVIRONMENT == 'production') {
                    if (isset($userData['phone']) && $userData['phone'] == '8976677224') {
                        $otp = OTP_CODE;
                    } else {
                        $otp = GenRandomNumber(4);
                    }
                }
                $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                $userArray['otp'] = $otp;
                $userArray['otp_validity'] = $otpValidity;
                $userArray['latitude'] = $latitude;
                $userArray['longitude'] = $longitude;
                $this->commonWebserviceModel->updateData($userArray, 'tbl_users', 'id', $userData['id']);
                $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                    'phone' => $mobileNo,
                ));
                if (!empty($userDataFilter)) {
                    if (empty($userDataFilter['pin'])) {
                        $userDataFilter['is_pin_empty'] = 1;
                    } else {
                        $userDataFilter['is_pin_empty'] = 0;
                    }
                }
                $resourceTypeGuardData = $this->resource_type_model->getResourceTypeData(array(
                    'is_guard' => 1,
                    'is_multiple' => 1,
                    'is_login' => 1,
                    'is_active' => 1,
                    'society_id' => $societyId,
                ));
                $resourceTypeIdArray = [];
                if (!empty($resourceTypeGuardData)) {
                    foreach ($resourceTypeGuardData as $resourceTypeElement) {
                        $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                    }
                }
                $userSocietyIdArray = array();
                $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'user_id' => $userDataFilter['id'],
                    'resource_type_id' => $resourceTypeIdArray,
                    'is_multiple' => 1
                ));
                if (!empty($userSocietyData)) {
                    foreach ($userSocietyData as $userSocietyElement) {
                        $userSocietyIdArray[] = $userSocietyElement['society_id'];
                    }
                }
                $userSocietyIdArray = array_unique($userSocietyIdArray);

                $groupData = $this->commonWebserviceModel->getUserGroupsData(array(
                    'user_id' => $userDataFilter['id'],
                    'society_id' => $userSocietyIdArray,
                ));
                $groupId = isset($groupData['id']) ? $groupData['id'] : '';
                $permissions = isset($groupData['permissions']) ? $groupData['permissions'] : '';
                $unserializedData = unserialize($permissions);
                $permissionsArray = [];
                if(!empty($unserializedData)){
                    foreach ($permissionsToCheck as $key => $value) {
                        if (in_array("MobileGatekeeperApp|$key", $unserializedData)) {
                            $permissionsArray[] = $key;
                        }
                    }
                }

            }

            if ($appType == MANAGER_APP) {
                $otp = OTP_CODE;
                if (DEV_ENVIRONMENT == 'production') {
                    if (isset($userData['phone']) && $userData['phone'] == '8976677224') {
                        $otp = OTP_CODE;
                    } else {
                        $otp = GenRandomNumber(4);
                    }
                }
                $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                $userArray['otp'] = $otp;
                $userArray['otp_validity'] = $otpValidity;
                $this->commonWebserviceModel->updateData($userArray, 'tbl_users', 'id', $userData['id']);
                $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                    'phone' => $mobileNo,
                ));
                if (!empty($userDataFilter)) {
                    if (empty($userDataFilter['pin'])) {
                        $userDataFilter['is_pin_empty'] = 1;
                    } else {
                        $userDataFilter['is_pin_empty'] = 0;
                    }
                }
                $resourceTypeManagerData = $this->resource_type_model->getResourceTypeData(array(
                    'resource_type_name' => 'Manager',
                    'society_id' => $societyId,
                ));
                $userSocietyIdArray = array();
                $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'user_id' => $userDataFilter['id'],
                    'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                    'is_multiple' => 1
                ));
                if (!empty($userSocietyData)) {
                    foreach ($userSocietyData as $userSocietyElement) {
                        $userSocietyIdArray[] = $userSocietyElement['society_id'];
                    }
                }
                $userSocietyIdArray = array_unique($userSocietyIdArray);

                $groupData = $this->commonWebserviceModel->getUserGroupsData(array(
                    'user_id' => $userDataFilter['id'],
                    'society_id' => $userSocietyIdArray,
                ));
                $groupId = isset($groupData['id']) ? $groupData['id'] : '';
                $permissions = isset($groupData['permissions']) ? $groupData['permissions'] : '';
                $unserializedData = unserialize($permissions);
                
                $permissionsArray = [];
                if(!empty($unserializedData)){
                    foreach ($permissionsToCheck as $key => $value) {
                        if (in_array("MobileManagerApp|$key", $unserializedData)) {
                            $permissionsArray[] = $key;
                        }
                    }
                }
            }

            return $this->response(array(
                'status' => TRUE,
                'message' => lang('CommonWebService.login_successfully'),
                'data' => $userDataFilter,
                // "token" => $token,
                'response_code' => 200,
                'user_permission_array' => $permissionsArray,
            ), 200);

        }
    }


    public function submitOtp()// not
    {
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if ($appType == "member") {
            $this->validation->setRule('login_type', lang('CommonWebService.login_type'), 'required');
        }
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $userId = $this->request->getVar('user_id');
            $otp = $this->request->getVar('otp');
            $pin = $this->request->getVar('pin');
            $password = $this->request->getVar('password');
            $permissionsArray = array();
            if($appType == MEMBER_APP){
                $permissionsToCheck = customerAppPermission();
                $resourceTypeMemberData = $this->resource_type_model->getResourceTypeData(array(
                    'resource_type_name' => 'Member',
                    'society_id' => $societyId,
                ));
            }

            if($appType == GATE_KEEPER){
                $permissionsToCheck = gatekeeperAppPermission();
                $resourceTypeGuardData = $this->resource_type_model->getResourceTypeData(array(
                    'is_guard' => 1,
                    'is_multiple' => 1,
                    'is_login' => 1,
                    'is_active' => 1,
                    'society_id' => $societyId,
                ));
                $resourceTypeIdArray = [];
                if (!empty($resourceTypeGuardData)) {
                    foreach ($resourceTypeGuardData as $resourceTypeElement) {
                        $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                    }
                }
            }

            if($appType == MANAGER_APP){
                $permissionsToCheck = managerAppPermission();
                $resourceTypeManagerData = $this->resource_type_model->getResourceTypeData(array(
                    'resource_type_name' => 'Manager',
                    'society_id' => $societyId,
                ));
            }
            $loginType = $this->request->getVar('login_type');

             
            $filterArray = array(
                'id' => $userId,
            );
             
            $userData = $this->commonWebserviceModel->getUserSocietyData($filterArray);

            if ($appType == MEMBER_APP) {
                if (!empty($userData)) {
                    if (strtolower($loginType) == 'otp') {
                        $otpValidityTime = strtotime($userData['otp_validity']);
                        $currentTime = strtotime(date("Y-m-d H:i:s"));
                        if ($otp != $userData['otp']) {
                            return $this->response(array(
                                'status' => false,
                                'response_code' => 404,
                                'message' => lang('CommonWebService.invalid_otp_code'),
                                'data' => null
                            ), 400);
                        } else if ($currentTime > $otpValidityTime) {
                            return $this->response(array(
                                'status' => false,
                                'response_code' => 404,
                                'message' => lang('CommonWebService.otp_code_expired'),
                                'data' => null
                            ), 400);
                        } else {
                            $isUserMultipleFlat = 0;
                            $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;
                            $ownershipFlatMemberData = array();
                            $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'mobile_no' => $phoneNumber,
                            ));

                            if (!empty($flatMemberFoundData)) {
                                $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                                $ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                                if ($moduleType == 'ownership_flat') {
                                    $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                                        'is_latest' => 1,
                                        'is_active' => 1
                                    ));
                                    if (!empty($ownershipFlatMemberFoundData)) {
                                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                            'mobile_no' => $phoneNumber,
                                            'is_latest' => 1,
                                            'is_multiple' => 1,
                                            'is_active' => 1
                                        ));
                                    }
                                } else if ($moduleType == 'rentals') {
                                    $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                                        'check_rental_start' => 1,
                                        'is_active' => 1
                                    ));
                                    if (!empty($rentalMemberFoundData)) {
                                        $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                                            'mobile_no' => $phoneNumber,
                                            'is_multiple' => 1,
                                            'is_active' => 1
                                        ));
                                    }
                                }
                            }

                            $isUserMultipleFlat = count($ownershipFlatMemberData);
                            $userDataSocietyFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                                'user_id' => $userData['id'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'is_society_id_group' => 1,
                                'is_multiple' => 1
                            ));

                            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                                'user_id' => $userData['id'],
                                'is_multiple' => 1
                            ));
                            $isUserMultipleSociety = count($userDataSocietyFilter);
                            //                          echo 'flat ='.$isUserMultipleFlat;
                            //                          echo "<br/>";
                            //                          echo 'society = '.$isUserMultipleSociety;
                            //                          echo "<br/>";
                            $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                                'id' => $userId
                            ));

                            $isUserSocietyApi = 0;
                            $isFlatSelectRequired = 0;
                            $isSocietySelectRequired = 0;
                            $token = '';
                            //                          if(count($userDataSocietyFilter) > 1){
                            //                              $isUserSocietyApi = 1;
                            //                              $token = '';
                            //                          }
                            if ($isUserMultipleSociety > 1 && $isUserMultipleFlat > 1) {
                                $isSocietySelectRequired = 1;
                                $isFlatSelectRequired = 1;
                            } else if ($isUserMultipleSociety == 1 && $isUserMultipleFlat > 1) {
                                $isSocietySelectRequired = 0;
                                $isFlatSelectRequired = 1;
                            } else if ($isUserMultipleSociety == 1 && $isUserMultipleFlat == 1) {
                                //$isUserSocietyApi = 0;
                                $jwtSecretKey = getenv('JWT_SECRET');
                                $iat = time(); // current timestamp value
                                //$exp = $iat + 36000;
                                $exp = $iat + (30 * 86400); // Expires in 7 days
                                $payload = array(
                                    "iss" => "Issuer of the JWT",
                                    "aud" => "Audience that the JWT",
                                    "sub" => "Subject of the JWT",
                                    "iat" => $iat, //Time the JWT issued at
                                    "exp" => $exp, // Expiration time of token
                                    "email" => $userData['email'],
                                    "user_id" => $userData['id']
                                );
                                $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                            }

                            if (!empty($userDataFilter)) {
                                $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                                $userDataFilter['is_society_api'] = $isUserSocietyApi;
                                $userDataFilter['is_society_selection_required'] = $isSocietySelectRequired;
                                $userDataFilter['is_society_flat_selection_required'] = $isFlatSelectRequired;
                                $userDataFilter['user_society_data'] = $userDataSocietyFilter;
                                $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;

                                // printArray($userDataPermissionFilter);
                                // printArray($permissionsToCheck,1);

                                if($isSocietySelectRequired == 0 && $isFlatSelectRequired == 0){
                                    if(!empty($userDataPermissionFilter)){
                                        $permissions = $userDataPermissionFilter[0]['permissions'];
                                        $unserializedData = unserialize($permissions);
                                        $permissionsArray = [];
                                        if(!empty($unserializedData)){
                                            foreach ($permissionsToCheck as $key => $value) {
                                                if (in_array("MobileCustomerApp|$key", $unserializedData)) {
                                                    $permissionsArray[] = $key;
                                                }
                                            }
                                        }                                    
                                    }
                                }
                            }
                            return $this->response(array(
                                'status' => true,
                                'response_code' => 200,
                                'message' => lang('CommonWebService.otp_verified_successfully'),
                                'data' => $userDataFilter,
                                'user_permission_array' => $permissionsArray,
                                "token" => $token,
                            ), 200);
                        }

                    }
                    if (strtolower($loginType) == 'password') {
                        $dbPassword = $userData['password'];
                        $checkPasswordData = $this->commonWebserviceModel->passwordCheck(array(
                            'db_password' => $dbPassword,
                            'password' => $password
                        ));
                        if (!$checkPasswordData) {
                            return $this->response(array(
                                'status' => FALSE,
                                'message' => lang('CommonWebService.invalid_password'),
                                'data' => null,
                                'response_code' => 200,
                            ), 200);
                        } else {
                            $isUserMultipleFlat = 0;
                            $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;
                            $ownershipFlatMemberData = array();
                            $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'mobile_no' => $phoneNumber,
                            ));

                            if (!empty($flatMemberFoundData)) {
                                $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                                $ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                                if ($moduleType == 'ownership_flat') {
                                    $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                                        'is_latest' => 1,
                                        'is_active' => 1
                                    ));
                                    if (!empty($ownershipFlatMemberFoundData)) {
                                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                            'mobile_no' => $phoneNumber,
                                            'is_latest' => 1,
                                            'is_multiple' => 1,
                                            'is_active' => 1
                                        ));
                                    }
                                } else if ($moduleType == 'rentals') {
                                    $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                                        'check_rental_start' => 1,
                                        'is_active' => 1
                                    ));
                                    if (!empty($rentalMemberFoundData)) {
                                        $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                                            'mobile_no' => $phoneNumber,
                                            'is_multiple' => 1,
                                            'is_active' => 1
                                        ));
                                    }
                                }
                            }

                            $isUserMultipleFlat = count($ownershipFlatMemberData);

                            $userDataSocietyFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                                'user_id' => $userData['id'],
                                'is_society_id_group' => 1,
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'is_multiple' => 1
                            ));

                            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                                'user_id' => $userData['id'],
                                'is_multiple' => 1
                            ));
                            $isUserMultipleSociety = count($userDataSocietyFilter);

                            $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                                'id' => $userId
                            ));

                            $isUserSocietyApi = 0;
                            $isFlatSelectRequired = 0;
                            $isSocietySelectRequired = 0;
                            $token = '';

                            if ($isUserMultipleSociety > 1 && $isUserMultipleFlat > 1) {
                                $isSocietySelectRequired = 1;
                                $isFlatSelectRequired = 1;
                            } else if ($isUserMultipleSociety == 1 && $isUserMultipleFlat > 1) {
                                $isSocietySelectRequired = 0;
                                $isFlatSelectRequired = 1;
                            } else if ($isUserMultipleSociety == 1 && $isUserMultipleFlat == 1) {
                                $jwtSecretKey = getenv('JWT_SECRET');
                                $iat = time(); // current timestamp value
                                //$exp = $iat + 36000;
                                $exp = $iat + (30 * 86400); // Expires in 7 days
                                $payload = array(
                                    "iss" => "Issuer of the JWT",
                                    "aud" => "Audience that the JWT",
                                    "sub" => "Subject of the JWT",
                                    "iat" => $iat, //Time the JWT issued at
                                    "exp" => $exp, // Expiration time of token
                                    "email" => $userData['email'],
                                    "user_id" => $userData['id']
                                );
                                $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                            }

                            if (!empty($userDataFilter)) {
                                $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                                $userDataFilter['is_society_api'] = $isUserSocietyApi;
                                $userDataFilter['is_society_selection_required'] = $isSocietySelectRequired;
                                $userDataFilter['is_society_flat_selection_required'] = $isFlatSelectRequired;
                                $userDataFilter['user_society_data'] = $userDataSocietyFilter;
                                $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;




                                if($isSocietySelectRequired == 0 && $isFlatSelectRequired == 0){
                                    if(!empty($userDataPermissionFilter)){
                                        $permissions = $userDataPermissionFilter[0]['permissions'];
                                        $unserializedData = unserialize($permissions);
                                        $permissionsArray = [];
                                        foreach ($permissionsToCheck as $key => $value) {
                                            if (in_array("MobileCustomerApp|$key", $unserializedData)) {
                                                $permissionsArray[] = $key;
                                            }
                                        }                                    
                                    }
                                }
                            }
                            return $this->response(array(
                                'status' => true,
                                'response_code' => 200,
                                'message' => lang('CommonWebService.password_verified_successfully'),
                                'data' => $userDataFilter,
                                 'user_permission_array' => $permissionsArray,
                                "token" => $token,
                            ), 200);
                        }
                    }

                } else {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strtoupper($loginType) . ' ' . lang('CommonWebService.verified_unsuccessfully'),
                        'data' => null
                    ), 400);
                }
            }


            if ($appType == GATE_KEEPER) {
                $isUpdatePinRequired = 0;
                if (!empty($userData)) {
                    if (empty($userData['pin'])) {
                        $isUpdatePinRequired = 1;
                        if (empty($pin)) {
                            return $this->response(array(
                                'status' => FALSE,
                                'message' => "Please Enter Pin",
                                'data' => null,
                                'response_code' => 400,
                            ), 400);
                        }
                    }

                    $otpValidityTime = strtotime($userData['otp_validity']);
                    $currentTime = strtotime(date("Y-m-d H:i:s"));
                    if ($otp != $userData['otp']) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.invalid_otp_code'),
                            'data' => null
                        ), 400);
                    } else if ($currentTime > $otpValidityTime) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.otp_code_expired'),
                            'data' => null
                        ), 400);
                    } else {
                        if ($isUpdatePinRequired == 1 || $pin != '') {
                            $filterPin = $this->ionAuthModel->hashPassword($pin);
                            $userPinArray['pin'] = $filterPin;
                            $userPinArray['updated_at'] = date('Y-m-d H:i:s');
                            $userPinArray['updated_by'] = $userData['id'];
                            $this->commonWebserviceModel->updateData($userPinArray, 'tbl_users', 'id', $userData['id']);
                        }


                        $userDataSocietyFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                            'user_id' => $userData['id'],
                            'resource_type_id' => $resourceTypeIdArray,
                            'is_society_id_group' => 1,
                            'is_multiple' => 1
                        ));
                        if (count($userDataSocietyFilter) > 1) {
                            $isUserSocietyApi = 1;
                            $token = '';
                        } else {
                            $isUserSocietyApi = 0;
                            $jwtSecretKey = getenv('JWT_SECRET');
                            $iat = time(); // current timestamp value
                            //$exp = $iat + 36000;
                            $exp = $iat + (30 * 86400); // Expires in 7 days
                            $payload = array(
                                "iss" => "Issuer of the JWT",
                                "aud" => "Audience that the JWT",
                                "sub" => "Subject of the JWT",
                                "iat" => $iat, //Time the JWT issued at
                                "exp" => $exp, // Expiration time of token
                                "email" => $userData['email'],
                                "user_id" => $userData['id']
                            );
                            $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                        }
                        $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                            'id' => $userId
                        ));

                        $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                            'user_id' => $userId,
                            'is_multiple' => 1
                        ));

                        if(!empty($userDataPermissionFilter)){
                            $permissions = $userDataPermissionFilter[0]['permissions'];
                            $unserializedData = unserialize($permissions);
                            $permissionsArray = [];
                            if(!empty($unserializedData)){
                                foreach ($permissionsToCheck as $key => $value) {
                                    if (in_array("MobileGatekeeperApp|$key", $unserializedData)) {
                                        $permissionsArray[] = $key;
                                    }
                                }
                            }                                    
                        }

                        if (!empty($userDataFilter)) {
                            $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                            $userDataFilter['is_society_api'] = $isUserSocietyApi;
                            $userDataFilter['is_society_selection_required'] = $isUserSocietyApi;
                            $userDataFilter['user_society_data'] = $userDataSocietyFilter;
                        }

                        return $this->response(array(
                            'status' => true,
                            'response_code' => 200,
                            'message' => lang('CommonWebService.otp_verified_successfully'),
                            'data' => $userDataFilter,
                             'user_permission_array' => $permissionsArray,
                            "token" => $token,
                        ), 200);
                    }
                }
            }

            if ($appType == MANAGER_APP) {
                if (!empty($userData)) {
                    $otpValidityTime = strtotime($userData['otp_validity']);
                    $currentTime = strtotime(date("Y-m-d H:i:s"));
                    if ($otp != $userData['otp']) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.invalid_otp_code'),
                            'data' => null
                        ), 400);
                    } else if ($currentTime > $otpValidityTime) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => lang('CommonWebService.otp_code_expired'),
                            'data' => null
                        ), 400);
                    } else {
                        $userDataSocietyFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                            'user_id' => $userData['id'],
                            'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                            'is_society_id_group' => 1,
                            'is_multiple' => 1
                        ));
                        if (count($userDataSocietyFilter) > 1) {
                            $isUserSocietyApi = 1;
                            $token = '';
                        } else {
                            $isUserSocietyApi = 0;
                            $jwtSecretKey = getenv('JWT_SECRET');
                            $iat = time(); // current timestamp value
                            //$exp = $iat + 36000;
                            $exp = $iat + (30 * 86400); // Expires in 7 days
                            $payload = array(
                                "iss" => "Issuer of the JWT",
                                "aud" => "Audience that the JWT",
                                "sub" => "Subject of the JWT",
                                "iat" => $iat, //Time the JWT issued at
                                "exp" => $exp, // Expiration time of token
                                "email" => $userData['email'],
                                "user_id" => $userData['id']
                            );
                            $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                        }
                        $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                            'id' => $userId
                        ));

                        $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                            'user_id' => $userId,
                            'is_multiple' => 1
                        ));

                        if(!empty($userDataPermissionFilter)){
                            $permissions = $userDataPermissionFilter[0]['permissions'];
                            $unserializedData = unserialize($permissions);
                            $permissionsArray = [];
                            if(!empty($unserializedData)){
                                foreach ($permissionsToCheck as $key => $value) {
                                    if (in_array("MobileManagerApp|$key", $unserializedData)) {
                                        $permissionsArray[] = $key;
                                    }
                                }
                            }                                    
                        }
                        if (!empty($userDataFilter)) {
                            $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                            $userDataFilter['is_society_api'] = $isUserSocietyApi;
                            $userDataFilter['is_society_selection_required'] = $isUserSocietyApi;
                            $userDataFilter['user_society_data'] = $userDataSocietyFilter;
                        }
                        return $this->response(array(
                            'status' => true,
                            'response_code' => 200,
                            'message' => lang('CommonWebService.otp_verified_successfully'),
                            'data' => $userDataFilter,
                             'user_permission_array' => $permissionsArray,
                            "token" => $token,
                        ), 200);
                    }
                }
            }
        }
    }

    public function resendOtp()// not
    {
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                'status' => FALSE,
                'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                'data' => null,
                'response_code' => 400,
            ), 400);
        } else {
            $userId = $this->request->getVar('user_id');
            $appType = $this->request->getVar('app_type');

              
            $filterArray = array(
                'id' => $userId,
            );
              
            $userData = $this->commonWebserviceModel->getUserSocietyData($filterArray);

            if (!empty($userData)) {
                $otpValidityTime = strtotime($userData['updated_at'], strtotime("-60 seconds"));
                $currentTime = strtotime(date("Y-m-d H:i:s", strtotime("-60 seconds")));
                if ($currentTime < $otpValidityTime) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => lang('CommonWebService.otp_send_every_second'),
                        'data' => null
                    ), 400);
                } else {
                    $otp = OTP_CODE;
                    $mobileNo = isset($userData['phone']) ? $userData['phone'] : "";
                    if (DEV_ENVIRONMENT == 'production') {
                        if ($mobileNo == '8976677224') {
                            $otp = OTP_CODE;
                        } else {
                            $otp = GenRandomNumber(6);
                        }
                    }
                    $otpValidity = date('Y-m-d H:i:s', strtotime(' +15 minutes'));
                    $otpArray = array(
                        'id' => $userId,
                        'otp' => $otp,
                        'otp_validity' => $otpValidity,
                        'updated_at' => DATE_TIME_DATABASE
                    );

                    $this->commonWebserviceModel->updateData($otpArray, 'tbl_users', 'id', $userId);

                    // if (DEV_ENVIRONMENT == 'production') {
                    //      sendSmsOtp($mobileNo,$otp . " is the OTP for your Tripwell account. Keep this OTP to yourself and do not share with anyone for account safety. - TRIPWELL TAXI SERVICES PRIVATE LIMITED",1207167430511390056);
                    // }

                    $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                        'phone' => $mobileNo
                    ));

                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => lang('CommonWebService.otp_send_successfully'),
                        'data' => $userDataFilter,
                    ), 200);
                }
            } else {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => null
                ), 400);
            }
        }
    }

    function getUserSocietyList()// not
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $userId = $this->request->getVar('user_id');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('start', lang('CommonWebService.start'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $start = ($start <= 0) ? 1 : (($start == 1) ? 0 : $start - 1);
            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                'user_id' => $userId,
                "is_multiple" => 1,
                'search' => $search,
                "is_society_id_group" => 1,
                'start' => $start,
            ));
            if (!empty($userSocietyData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.user_society_listing_successfully'),
                    'data' => $userSocietyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                //return $this->respond($data,200);
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $userSocietyData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                //return $this->respond($data,404);
                return $this->response($data, 404);
            }
        }
    }

    function userSocietyLogin()// not
    {
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $permissionsArray = array();
            if($appType == MEMBER_APP){
                $permissionsToCheck = customerAppPermission();
            }

            if($appType == GATE_KEEPER){
                $permissionsToCheck = gatekeeperAppPermission();
            }

            if($appType == MANAGER_APP){
                $permissionsToCheck = managerAppPermission();
            }
            if ($appType == MEMBER_APP) {
                $filterArray = array(
                    'id' => $userId,
                );
                $userData = $this->commonWebserviceModel->getUserSocietyData($filterArray);

                $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                    'user_id' => $userId,
                    'is_society_id_group' => 1,
                    'society_id' => $societyId,
                    'is_multiple' => 1,
                ));

                $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                    'user_id' => $userId,
                    'society_id' => $societyId,
                    'is_multiple' => 1
                ));

                if (empty($userSocietyData)) {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.invalid_society'),
                        'data' => $userSocietyData,
                        'response_code' => 404,
                    );
                    //return $this->respond($data,404);
                    return $this->response($data, 404);
                }

                $isUserMultipleFlat = 0;
                $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;
                $ownershipFlatMemberData = array();

                $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'mobile_no' => $phoneNumber,
                    'society_id' => $societyId
                ));

                if (!empty($flatMemberFoundData)) {
                    $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                    $ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                    if ($moduleType == 'ownership_flat') {
                        $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'society_id' => $societyId,
                            'is_latest' => 1,
                            'is_active' => 1
                        ));
                        if (!empty($ownershipFlatMemberFoundData)) {
                            $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                                'mobile_no' => $phoneNumber,
                                'society_id' => $societyId,
                                'is_latest' => 1,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                        }
                    } else if ($moduleType == 'rentals') {
                        $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'society_id' => $societyId,
                            'check_rental_start' => 1,
                            'is_active' => 1
                        ));
                        if (!empty($rentalMemberFoundData)) {
                            $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                                'mobile_no' => $phoneNumber,
                                'society_id' => $societyId,
                                'is_multiple' => 1,
                                'is_active' => 1
                            ));
                        }
                    }
                }

                $isUserMultipleFlat = count($ownershipFlatMemberData);
                $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                    'id' => $userId
                ));

                if ($isUserMultipleFlat > 1) {
                    if (!empty($userDataFilter)) {
                        $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                        $userDataFilter['is_society_flat_selection_required'] = 1;
                        $userDataFilter['user_society_data'] = $userSocietyData;
                        $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;
                    }
                    if (!empty($userDataFilter)) {
                        $data = array(
                            'status' => true,
                            'message' => lang('CommonWebService.user_society_login_successfully'),
                            'data' => $userDataFilter,
                            'user_permission_array' => $permissionsArray,
                            'response_code' => 200,
                        );
                        return $this->response($data, 200);
                    } else {
                        $data = array(
                            'status' => false,
                            'message' => lang('CommonWebService.no_data_found'),
                            'data' => $userDataFilter,
                            'response_code' => 404,
                        );
                        return $this->response($data, 404);
                    }
                } else {
                    $jwtSecretKey = getenv('JWT_SECRET');
                    $iat = time(); // current timestamp value
                    //$exp = $iat + 36000; // Expires in 10 hours
                    $exp = $iat + (30 * 86400); // Expires in 7 days
                    $payload = array(
                        "iss" => "Issuer of the JWT",
                        "aud" => "Audience that the JWT",
                        "sub" => "Subject of the JWT",
                        "iat" => $iat, //Time the JWT issued at
                        "exp" => $exp, // Expiration time of token
                        "email" => $userDataFilter['email'],
                        "user_id" => $userDataFilter['id'],
                    );
                    $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                    if (!empty($userDataFilter)) {
                        $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                        $userDataFilter['is_society_flat_selection_required'] = 0;
                        $userDataFilter['user_society_data'] = $userSocietyData;
                        $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;
                    }

                    if(!empty($userDataPermissionFilter)){
                        $permissions = $userDataPermissionFilter[0]['permissions'];
                        $unserializedData = unserialize($permissions);
                        $permissionsArray = [];
                        if(!empty($unserializedData)){
                            foreach ($permissionsToCheck as $key => $value) {
                                if (in_array("MobileCustomerApp|$key", $unserializedData)) {
                                    $permissionsArray[] = $key;
                                }
                            } 
                        }                                   
                    }

                    if (!empty($userDataFilter)) {
                        $data = array(
                            'status' => true,
                            'message' => lang('CommonWebService.user_society_login_successfully'),
                            'data' => $userDataFilter,
                            'user_permission_array' => $permissionsArray,
                            'token' => $token,
                            'response_code' => 200,
                        );
                        return $this->response($data, 200);
                    } else {
                        $data = array(
                            'status' => false,
                            'message' => lang('CommonWebService.no_data_found'),
                            'data' => $userDataFilter,
                            'response_code' => 404,
                        );
                        return $this->response($data, 404);
                    }
                }
            }

            if ($appType == GATE_KEEPER || $appType == MANAGER_APP) {
                if ($appType == GATE_KEEPER) {

                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'user_id' => $userId,
                        'society_id' => $societyId,
                        'resource_type_id' => $resourceTypeIdArray,
                        'is_multiple' => 1,
                    ));

                    $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                        'user_id' => $userId,
                        'society_id' => $societyId,
                        'is_multiple' => 1
                    ));

                    if(!empty($userDataPermissionFilter)){
                        $permissions = $userDataPermissionFilter[0]['permissions'];
                        $unserializedData = unserialize($permissions);
                        $permissionsArray = [];
                        if(!empty($unserializedData)){
                            foreach ($permissionsToCheck as $key => $value) {
                                if (in_array("MobileGatekeeperApp|$key", $unserializedData)) {
                                    $permissionsArray[] = $key;
                                }
                            } 
                        }                                   
                    }

                }
                else if ($appType == MANAGER_APP) {
                    $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                        'user_id' => $userId,
                        'society_id' => $societyId,
                        'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
                        'is_multiple' => 1,
                    ));

                    $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                        'user_id' => $userId,
                        'society_id' => $societyId,
                        'is_multiple' => 1
                    ));

                    if(!empty($userDataPermissionFilter)){
                        $permissions = $userDataPermissionFilter[0]['permissions'];
                        $unserializedData = unserialize($permissions);
                        $permissionsArray = [];
                        if(!empty($unserializedData)){
                            foreach ($permissionsToCheck as $key => $value) {
                                if (in_array("MobileManagerApp|$key", $unserializedData)) {
                                    $permissionsArray[] = $key;
                                }
                            }
                        }                                        
                    }
                }

                if (empty($userSocietyData)) {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.invalid_society'),
                        'data' => $userSocietyData,
                        'response_code' => 404,
                    );
                    //return $this->respond($data,404);
                    return $this->response($data, 404);
                }
                $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                    'id' => $userId
                ));
                $jwtSecretKey = getenv('JWT_SECRET');
                $iat = time(); // current timestamp value
                //$exp = $iat + 36000;
                $exp = $iat + (30 * 86400); // Expires in 7 days
                $payload = array(
                    "iss" => "Issuer of the JWT",
                    "aud" => "Audience that the JWT",
                    "sub" => "Subject of the JWT",
                    "iat" => $iat, //Time the JWT issued at
                    "exp" => $exp, // Expiration time of token
                    "email" => $userDataFilter['email'],
                    "user_id" => $userDataFilter['id'],
                );
                $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
                if (!empty($userDataFilter)) {
                    $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                    $userDataFilter['user_society_data'] = $userSocietyData;
                }
                if (!empty($userDataFilter)) {
                    $data = array(
                        'status' => true,
                        'message' => lang('CommonWebService.user_society_login_successfully'),
                        'data' => $userDataFilter,
                        'user_permission_array' => $permissionsArray,
                        'token' => $token,
                        'response_code' => 200,
                    );
                    return $this->response($data, 200);
                } else {
                    $data = array(
                        'status' => false,
                        'message' => lang('CommonWebService.no_data_found'),
                        'data' => $userDataFilter,
                        'response_code' => 404,
                    );
                    return $this->response($data, 404);
                }
            }

        }
    }


    function getUserSocietyFlatList()// not
    {
        $start = $this->request->getVar('start');
        $search = $this->request->getVar('search');
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $filterArray = array(
                'id' => $userId,
            );
            $userData = $this->commonWebserviceModel->getUserSocietyData($filterArray);

            $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;
            $ownershipFlatMemberData = array();

            $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'mobile_no' => $phoneNumber,
            ));

            if (!empty($flatMemberFoundData)) {
                $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                $ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                if ($moduleType == 'ownership_flat') {
                    $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_latest' => 1,
                        'is_active' => 1
                    ));
                    if (!empty($ownershipFlatMemberFoundData)) {
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'mobile_no' => $phoneNumber,
                            'society_id' => $societyId,
                            'is_latest' => 1,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));
                    }
                } else if ($moduleType == 'rentals') {
                    $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'check_rental_start' => 1,
                        'is_active' => 1
                    ));
                    if (!empty($rentalMemberFoundData)) {
                        $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                            'mobile_no' => $phoneNumber,
                            'society_id' => $societyId,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));
                    }
                }
            }

            if (!empty($ownershipFlatMemberData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.user_society_flat_listing_successfully'),
                    'data' => $ownershipFlatMemberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $ownershipFlatMemberData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    function userSocietyFlatLogin()// not
    {
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $permissionsArray = array();
            $permissionsToCheck = customerAppPermission();
            $userSocietyData = $this->commonWebserviceModel->getUserSocietyData(array(
                'user_id' => $userId,
                'society_id' => $societyId,
                'is_multiple' => 1,
            ));
            $userDataPermissionFilter = $this->commonWebserviceModel->getUserGroupsData(array(
                'user_id' => $userId,
                'society_id' => $societyId,
                'is_multiple' => 1
            ));
            $filterArray = array(
                'id' => $userId,
            );
            $userData = $this->commonWebserviceModel->getUserSocietyData($filterArray);

            $phoneNumber = isset($userData['phone']) ? $userData['phone'] : -9;

            $flatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'mobile_no' => $phoneNumber,
            ));


            if (!empty($flatMemberFoundData)) {
                $moduleType = isset($flatMemberFoundData['type']) ? $flatMemberFoundData['type'] : '';
                //$ownershipFlatMemberId = isset($flatMemberFoundData['ownership_flat_member_id']) ? $flatMemberFoundData['ownership_flat_member_id'] : -9;

                if ($moduleType == 'ownership_flat') {
                    $ownershipFlatMemberFoundData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'is_latest' => 1,
                        'is_active' => 1
                    ));
                    if (!empty($ownershipFlatMemberFoundData)) {
                        $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'society_id' => $societyId,
                            'is_latest' => 1,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));
                    }
                } else if ($moduleType == 'rentals') {
                    $rentalMemberFoundData = $this->rentalModel->getRentalsMemberData(array(
                        'ownership_flat_member_id' => $ownershipFlatMemberId,
                        'check_rental_start' => 1,
                        'is_active' => 1
                    ));
                    if (!empty($rentalMemberFoundData)) {
                        $ownershipFlatMemberData = $this->rentalModel->getRentalsMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberId,
                            'society_id' => $societyId,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));
                    }
                }
            }

            if (empty($ownershipFlatMemberData)) {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.invalid_society_flat'),
                    'data' => $ownershipFlatMemberData,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
            $userDataFilter = $this->commonWebserviceModel->getUserSocietyData(array(
                'id' => $userId
            ));
            $jwtSecretKey = getenv('JWT_SECRET');
            $iat = time(); // current timestamp value
            //$exp = $iat + 36000;
            $exp = $iat + (30 * 86400); // Expires in 7 days
            $payload = array(
                "iss" => "Issuer of the JWT",
                "aud" => "Audience that the JWT",
                "sub" => "Subject of the JWT",
                "iat" => $iat, //Time the JWT issued at
                "exp" => $exp, // Expiration time of token
                "email" => $userDataFilter['email'],
                "user_id" => $userDataFilter['id'],
            );
            $token = JWT::encode($payload, $jwtSecretKey, 'HS256');
            if (!empty($userDataFilter)) {
                $userType = isset($userDataFilter['resource_type_id']) ? $userDataFilter['resource_type_id'] : '';
                $userDataFilter['user_society_data'] = $userSocietyData;
                $userDataFilter['user_society_flat_data'] = $ownershipFlatMemberData;

                if(!empty($userDataPermissionFilter)){
                    $permissions = $userDataPermissionFilter[0]['permissions'];
                    $unserializedData = unserialize($permissions);
                    $permissionsArray = [];
                    if(!empty($unserializedData)){
                        foreach ($permissionsToCheck as $key => $value) {
                            if (in_array("MobileCustomerApp|$key", $unserializedData)) {
                                $permissionsArray[] = $key;
                            }
                        } 
                    }                                   
                }
            }
            if (!empty($userDataFilter)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.user_society_flat_login_successfully'),
                    'data' => $userDataFilter,
                    'user_permission_array' => $permissionsArray,
                    'token' => $token,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $userDataFilter,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }

    public function getProfileList() // Not
    {
        $societyId = $this->request->getVar('society_id');
        $userId = $this->request->getVar('user_id');
        $appType = $this->request->getVar('app_type');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('app_type', lang('CommonWebService.app_type'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'limit' => DATA_LIMIT,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $profileData = array();
            $resourceTypeGuardData = $this->resource_type_model->getResourceTypeData(array(
                'is_guard' => 1,
                'is_multiple' => 1,
                'is_login' => 1,
                'is_active' => 1,
                'society_id' => $societyId,
            ));
            $resourceTypeIdArray = [];
            if (!empty($resourceTypeGuardData)) {
                foreach ($resourceTypeGuardData as $resourceTypeElement) {
                    $resourceTypeIdArray[] = isset($resourceTypeElement['resource_type_id']) ? $resourceTypeElement['resource_type_id'] : 0;
                }
            }
            $type = '';
            $typeId = '';
            $filterArray = array(
                'society_id' => $societyId,
                'user_id' => $userId,
                'resource_type_id' => $resourceTypeIdArray,
            );
            $userSocietyData = $this->ionAuthModel->getUserSocietyWiseData($filterArray);

            $type = isset($userSocietyData['type']) ? $userSocietyData['type'] : '';
            $typeId = isset($userSocietyData['type_id']) ? $userSocietyData['type_id'] : '';
            if ($type == GATE_KEEPER) {
                $profileData = $this->resourceModel->getResourceData(array("resource_id" => $typeId, 'society_id' => $societyId,'is_helper' => 1));
                if (!empty($profileData)) {
                    $profileData['date_of_birth'] = isset($profileData['date_of_birth']) ? YMDToDMY($profileData["date_of_birth"]) : "";
                    $profileData['working_hours'] = "10:00 AM To 07:00 PM";
                    $profileData['support_number'] = "-";
                    $resourceImageData = $this->visitorModel->getDocumentImageData(array(
                        "document_type_id" => $typeId,
                        "document_type" => 'resource',
                        "is_multiple" => 1
                    ));
                    if (!empty($resourceImageData)) {
                        foreach ($resourceImageData as $siKey => $resourceImageElement) {
                            $paths = '';
                            $thumbnailPaths = '';
                            if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
                                $paths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
                            }
                            if (file_exists(THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'])) {
                                $thumbnailPaths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $resourceImageElement['document_image'];
                            }
                            $resourceImageData[$siKey]['thumbnail_document_image'] = $thumbnailPaths;
                            $resourceImageData[$siKey]['document_image'] = $paths;
                        }
                    }
                    $profileData['resource_image_data'] = $resourceImageData;
                }
            }
            if (!empty($profileData)) {
                $data = array(
                    'status' => true,
                    'message' => lang('CommonWebService.profile_listing_successfully'),
                    'data' => $profileData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 200,
                );
                return $this->response($data, 200);
            } else {
                $data = array(
                    'status' => false,
                    'message' => lang('CommonWebService.no_data_found'),
                    'data' => $profileData,
                    'limit' => DATA_LIMIT,
                    'response_code' => 404,
                );
                return $this->response($data, 404);
            }
        }
    }


    public function editProfile() // Not
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $resourceId = $this->request->getVar('resource_id');
        $resourceName = $this->request->getVar('resource_name');
        $resourceImage = $this->request->getVar('resource_image[]');
        $this->validation->setRule('resource_id', lang('CommonWebService.resource_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            $resourceImageData = array();
            if (isset($_FILES["resource_image"])) {
                $resourceImagePath = DOCUMENT_IMAGE_PATH;
                $resourceImageData = $dt_ci_file_upload->UploadMultipleFile('resource_image', MAX_IMAGE_SIZE_LIMIT, $resourceImagePath, true, true, array('jpeg', 'png', 'jpg'));
                if ($resourceImageData['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($resourceImageData['message']),
                        'data' => null
                    ), 404);
                }
                else{
                    unset($resourceImageData['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($resourceImageData, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
            }

            $resourceUpdateArray = array();
            $resourceArray = array(
                'resource_id' => $resourceId,
                'resource_name' => $resourceName,
                'is_guard' => 1,
                'is_active' => 1,
            );
            if (!empty($resourceId)) {
                $resourceUpdateArray = $this->resourceModel->getResourceData(array(
                    'resource_id' => $resourceId,
                ));
                $resourceUpdateArray = compareArray($resourceArray, $resourceUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $resourceData = $this->commonWebserviceModel->insertUpdateRecord($resourceArray, 'resource_id', 'tbl_resource', 1, '', array(), $extraData, $resourceUpdateArray);
            $lastResourceId = $resourceData['lastInsertedId'];


            $userUpdateArray = array();
            $userArray = array(
                'id' => $userId,
                'first_name' => $resourceName,
            );
            if (!empty($userId)) {
                $userUpdateArray = $this->commonWebserviceModel->getUserSocietyData(array(
                    'id' => $userId,
                ));
                $userUpdateArray = compareArray($userArray, $userUpdateArray);
            }
            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $userData = $this->commonWebserviceModel->insertUpdateRecord($userArray, 'id', 'tbl_users', 1, '', array(), $extraData, $userUpdateArray);
            $lastUserId = $userData['lastInsertedId'];


            // resource Multiple Image Store
            if ($lastResourceId != '') {
                if (isset($resourceImageData) && count($resourceImageData) > 0) {
                    $batchArray = array();
                    unset($resourceImageData['success']);
                    foreach ($resourceImageData as $key => $imageData) {
                        $dataArray = array(
                            'document_image_id' => '',
                            'document_type' => 'resource',
                            'document_type_id' => $lastResourceId,
                            'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                            'created_by' => $userId,
                            'updated_by' => $userId,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $resourceExtraDataArray = array();
                    $resourceExtraDataArray['module_id'] = $lastResourceId;
                    $resourceExtraDataArray['module'] = 'Resource Image';
                    $resourceExtraDataArray['type'] = 'Resource';
                    $resourceExtraDataArray['old_data'] = '';
                    $resourceExtraDataArray['user_id'] = $userId;
                    $resourceExtraDataArray['society_id'] = $societyId;
                    $this->commonWebserviceModel->batchInsert($batchArray, 'tbl_document_image', $resourceExtraDataArray);
                }
            }
            if (isset($resourceData['success']) && $resourceData['success']) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.edit_profile')),
                    'data' => null
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.edit_profile')),
                    'data' => null
                ), 404);
            }
        }
    }

    public function addEditMember() // Not
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userId = $this->request->getVar('user_id');
        $userSocietyId = $this->request->getVar('user_society_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $name = $this->request->getVar('name');
        $email = $this->request->getVar('email');
        $mobileNo = $this->request->getVar('mobile_no');
        $gender = $this->request->getVar('gender');
        $relation = $this->request->getVar('relation');
        $birthDate = $this->request->getVar('birth_date');
        $bloodGroup = $this->request->getVar('blood_group');
        $relation = $this->request->getVar('relation');
        $foodLike = $this->request->getVar('food_like');
        $isOwner = $this->request->getVar('is_owner');
        $isEdit = $this->request->getVar('is_edit');
        $isStatusChange = $this->request->getVar('is_status_change');
        $memberImage = $this->request->getVar('member_image');
        $memberId = $this->request->getVar('member_id');
        $editMemberId = $this->request->getVar('edit_member_id');
        $ownershipFlatId = $this->request->getVar('ownership_flat_id');
        $remarks = $this->request->getVar('remarks');
        $useExistsMember = $this->request->getVar('use_exists_member');

        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        $this->validation->setRule('name', lang('CommonWebService.name'), 'required');
        $this->validation->setRule('mobile_no', lang('CommonWebService.mobile_no'), 'required');
        $this->validation->setRule('gender', lang('CommonWebService.gender'), 'required');
        $this->validation->setRule('birth_date', lang('CommonWebService.birth_date'), 'required');

        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {

            $existsMobileNoData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'mobile_no' => $mobileNo,
                'ownership_flat_id' => $ownershipFlatId,
                'member_id_not' => $memberId,
                'is_multiple' => 1,
            ));

            if (!empty($existsMobileNoData)) {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => "Members Mobiles Numbers Can't Be Same",
                    'data' => null
                ), 404);
            }

            $oldOwnershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                'type_id' => $ownershipFlatId,
                'is_multiple' => 1,
                'is_active' => 1,
                'society_id' => $societyId,
            ));

            $filterMobileNoArray = $this->request->getVar('mobile_no');

            if(isset($oldOwnershipFlatMemberData) && !empty($oldOwnershipFlatMemberData)){
                foreach($oldOwnershipFlatMemberData as $oldMemberData){
                    if(isset($oldMemberData['mobile_no'])) {
                        $filterMobileNoArray[] = $oldMemberData['mobile_no'];
                    }
                }
            }

            $filterMobileNoArray = array_filter($filterMobileNoArray, function($value, $key) {
                return !empty($value);
            }, ARRAY_FILTER_USE_BOTH);

            // Exists Member-Data
            $resourceTypeMemberId = getResourceTypeId(RESOURCE_TYPE_MEMBER);

            $existsUserData = $this->commonWebserviceModel->getUserSocietyData(array(
                'phone' => $filterMobileNoArray,
                'is_multiple' => 1
            ));

            $existsUserMemberData = $this->commonWebserviceModel->getUserSocietyData(array(
                'phone' => $filterMobileNoArray,
                'is_multiple' => 1,
                'is_member' => 1,
            ));

            $resourceTypeMemberData = $this->resourceTypeModel->getResourceTypeData(array(
                "resource_type_name" => RESOURCE_TYPE_MEMBER,
                "society_id" => $societyId,
            ));

            // if (!empty($isStatusChange)) {
            //     $ownershipFlatMemberArray = array(
            //         'ownership_flat_member_id' => $editMemberId,
            //         'is_active' => 0,
            //         'remarks' => $remarks,
            //     );
            // } else {

                if (isset($_FILES["member_image"])) {
                    $memberImagePath = FLAT_MEMBER_IMAGE_PATH;
                    $memberImageResult = $dt_ci_file_upload->uploadFile('member_image', MAX_IMAGE_SIZE_LIMIT, $memberImagePath, true, true, array('jpeg', 'png', 'jpg'));
                    if ($memberImageResult['success'] == false) {
                        return $this->response(array(
                            'status' => false,
                            'response_code' => 404,
                            'message' => strip_tags($memberImageResult['message']),
                            'data' => null
                        ), 404);
                    } else {
                        $memberImageRecord = $memberImageResult['file_name'];
                        unset($memberImageResult['success']);
                        $thumbnailResult =  $dt_ci_file_upload->ThumbnailUploadFile($memberImageResult, FLAT_MEMBER_IMAGE_PATH, THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
                    }
                }

                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1
                ));
                $ownershipFlatMemberUpdateArray = array();
                $ownershipFlatMembersData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'type' => $ownershipFlatMemberData['type'],
                    'type_id' => $ownershipFlatMemberData['type_id'],
                    'flat_id' => $ownershipFlatMemberData['flat_id'],
                    'mobile_no' => $mobileNo,
                    'member_id_not' => $editMemberId,
                    // 'is_multiple' => 1,
                ));

                if (!empty($ownershipFlatMembersData)) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => "Members Mobiles Numbers Can't Be Same",
                        'data' => null
                    ), 404);
                }

                // member-Data 
                $filterMemberIdArr = array_filter($filterMobileNoArray, function($value, $key) {
                    return !empty($value);
                }, ARRAY_FILTER_USE_BOTH);

                $memberDetailsData = array();
                if($filterMemberIdArr) {
                    $memberDetailsData = array_reduce($this->ownershipFlatModel->getMemberData(array(
                        'phone' => $filterMemberIdArr,
                        'is_multiple' => 1
                    )), function($carry, $item) {
                        $carry[$item['member_id']] = $item;
                        return $carry;
                    }, []);
                }

                if(!empty($memberId)){
                    $memberSlug = $memberDetailsData[$memberId]['member_slug'];
                } else {
                    $memberSlug = random_string();
                }

                $memberInsertArray = array(
                    'name' => $name,
                    'email_id' => $email,
                    'member_slug' => $memberSlug,
                    'mobile_no' => $mobileNo,
                    'gender' => $gender,
                    // 'relation' => $relation,
                    'birth_date' => DMYToYMD($birthDate),
                    'blood_group' => $bloodGroup,
                );
                if ($isEdit == 1) {
                    $memberInsertArray['member_id'] = $memberId;
                } else {
                    $memberInsertArray['member_id'] = '';
                }
                if (isset($memberImageRecord)) {
                    if ($isEdit == 1) {
                        $memberImageData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array('member_id' => $editMemberId, 'is_show_all_member' => 1));
                        $ownershipFlatMemberUpdateArray = $memberImageData;
                        if ($memberImageData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image'])) {
                            unlink(FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image']);
                        }
                        if ($memberImageData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image'])) {
                            unlink(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image']);
                        }
                    }
                    $memberInsertArray['member_image'] = $memberImageRecord;
                }

                $extraData = array();
                $extraObj['api_user_id'] = $userSocietyId;
                $extraObj['society_id'] = $societyId;
                $extraData['is_api_data'] = $extraObj;
                $memberData = $this->commonWebserviceModel->insertUpdateRecord($memberInsertArray, 'member_id', MASTER_DB.'.tbl_member', 1, '', array(), $extraData, array());
                $lastMemberId = $memberData['lastInsertedId'];

                $ownershipFlatMemberArray = array(
                    'type' => $ownershipFlatMemberData['type'],
                    'type_id' => $ownershipFlatMemberData['type_id'],
                    'member_id' => $lastMemberId,
                    'member_slug' => $memberSlug,
                    'relation' => $relation,
                    'ownership_flat_id' => $ownershipFlatId,
                    'is_owner' => $isOwner,
                    'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                    'is_active' => 1,
                );

                $insertUpdateOwnershipFlatMemberDetailArr[$memberSlug] = array(
                    'member_slug' => $memberSlug,
                    'mobile_no' => $mobileNo,
                );

                if ($isEdit == 1) {
                    $ownershipFlatMemberArray['ownership_flat_member_id'] = $editMemberId;
                } else {
                    $ownershipFlatMemberArray['ownership_flat_member_id'] = '';
                }
                if (isset($memberImageRecord)) {
                    if ($isEdit == 1) {
                        $memberImageData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array('ownership_flat_member_id' => $ownershipFlatMemberId, 'is_show_all_member' => 1));
                        $ownershipFlatMemberUpdateArray = $memberImageData;
                        if ($memberImageData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image'])) {
                            unlink(FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image']);
                        }
                        if ($memberImageData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image'])) {
                            unlink(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberImageData['member_image']);
                        }
                    }
                    $ownershipFlatMemberArray['member_image'] = $memberImageRecord;
                }
            // }


            if ($isEdit == 1 || $isStatusChange == 1) {
                $ownershipFlatMemberUpdateArray = $this->ownershipFlatModel->getOwnershipFlatMemberData(array('ownership_flat_member_id' => $ownershipFlatMemberId, 'is_show_all_member' => 1,'is_active' => 1));
                $ownershipFlatMemberUpdateArray = compareArray($ownershipFlatMemberArray, $ownershipFlatMemberUpdateArray);
            }

            $extraData = array();
            $extraObj['api_user_id'] = $userId;
            $extraObj['society_id'] = $societyId;
            $extraData['is_api_data'] = $extraObj;
            $memberData = $this->commonWebserviceModel->insertUpdateRecord($ownershipFlatMemberArray, 'ownership_flat_member_id', 'tbl_ownership_flat_member', 1, '', array(), $extraData, $ownershipFlatMemberUpdateArray);
            $lastOwnershipFlatMemberId = $memberData['lastInsertedId'];

            $groupData = $this->commonWebserviceModel->getGroupsData([
                'group_id' => $resourceTypeMemberData['group_id'],
                'society_id' => $societyId,
            ]);

            $groupId = $groupData['id'] ?? '';
            $permissions = $groupData['permissions'] ?? '';
            $permissionArray = unserialize($permissions);
            // printArray($permissionArray,1);
            $permissionLabel = [];
            $controllers_methods = $this->dt_ci_acl->getPermissableMethods();
            
            foreach ($controllers_methods as $controller_name => $methods_arr) {
                foreach ($methods_arr as $method) {
                    $methodDisplay = is_array($method) ? reset($method) : $method;
                    $methodActual = is_array($method) ? key($method) : $method;
                    $inputName = "$controller_name|$methodActual";
                    $permissionLabel[] = "$inputName|dt|$controller_name|dt|$methodDisplay";
                }
            }

            $ownershipFlatMemberInsertData = $this->ownershipFlatModel->getOwnershipFlatMemberData([
                'ownership_flat_id' => $ownershipFlatId,
                'ownership_flat_member_id' => $lastOwnershipFlatMemberId,
                'type' => 'ownership_flat',
                'is_multiple' => 1,
                'society_id' => $societyId,
            ]);

            // adding mobile No's
            foreach ($ownershipFlatMemberInsertData as $key => $value) {
                $ownershipFlatMemberInsertData[$key]['mobile_no'] = $insertUpdateOwnershipFlatMemberDetailArr[$value['member_slug']]['mobile_no'];
            }

            $oldMemberArr = array();
            foreach ($oldOwnershipFlatMemberData as $oKey => $oldMember) {
                $oldmemberComboKey = $oldMember['society_id'].'|'.$oldMember['ownership_flat_member_id'];
                $oldMemberArr[$oldmemberComboKey] = $oldMember;
            }

            $tblUsrInsertArr = [];
            $tblUsrUpdateArr = [];
            $tblUsrSocietyInsertArr = [];
            $tblUsrSocietyUpadteArr = [];
            $tblUsrGroupArr = [];
            $tblUsrPermissionArr = [];
            $deleteUserArr = [];
            $deleteMemberIdArr = [];
            $deleteUserIdArr = [];
            $deleteUserSocietyIdArr = [];

            $existsUserDataArr = array();
            $existsUserMobileNoWiseArr = array();
            if(!empty($existsUserData)){
                foreach($existsUserData as $existsUser) {
                    $comboKey = $existsUser['society_id']."|".$existsUser['resource_type_id']."|".$existsUser['type_id'];
                    $existsUserDataArr[$comboKey] = $existsUser;
                    $existsUserMobileNoWiseArr[$existsUser['phone']][] = $existsUser;
                }
            }

            $existsUserMemberDataArr = array();
            if(!empty($existsUserMemberData)){
                foreach($existsUserMemberData as $existsUserMember){
                    $comboKey=$existsUserMember['society_id']."|".$existsUserMember['resource_type_id']."|".$existsUserMember['type_id'];
                    $existsUserMemberDataArr[$comboKey] = $existsUserMember;
                }
            }

            foreach($ownershipFlatMemberInsertData as $newMember){
                $newMemberComboKey = $newMember['society_id']."|".$newMember['resource_type_id']."|".$newMember['member_id'];
                $newComboKey = $newMember['society_id']."|".$newMember['ownership_flat_member_id'];

                if(empty($existsUserData)){
                    // New User
                    $password = PASSWORD;
                    $slug = random_string();
                    $slugSociety = random_string();
                    if(!empty($newMember['mobile_no'])){
                        $tblUsrInsertArr[] = [
                            'username' => $newMember['email_id'],
                            'email' => $newMember['email_id'],
                            'first_name' => $newMember['name'],
                            // 'phone' => $newMember['mobile_no'],
                            'user_type_id' => $newMember['member_id'],
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'password' => $this->ionAuthModel->hashPassword($password),
                            'active' => 1,
                            'slug' => $slug,
                        ];
                
                        $tblUsrGroupArr[] = [
                            'id' => '',
                            'group_id' => $groupId,
                            'slug' => $slug,
                        ];
                
                        $tblUsrSocietyInsertArr[] = [
                            'user_society_id' => '',
                            'society_id' => $societyId,
                            'phone' => $newMember['mobile_no'],
                            'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                            'type_id' => $newMember['member_id'],
                            'slug' => $slug,
                            'society_slug' => $slugSociety,
                        ];

                        foreach ($permissionLabel as $labelData) {
                            list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                            if (in_array($permissionValue, $permissionArray)) {
                                $tblUsrPermissionArr[] = [
                                    'controller_name' => $controller,
                                    'permission_name' => $permissionValue,
                                    'permission_label' => $label,
                                    'group_id' => $resourceTypeMemberData['group_id'],
                                    'slug' => $slug,
                                    'society_slug' => $slugSociety,
                                    'created_at' => date('Y-m-d H:i:s'),
                                    'created_by' => $userSocietyId,
                                    'updated_at' => date('Y-m-d H:i:s'),
                                    'updated_by' => $userSocietyId,
                                ];
                            }
                        }
                    }
                }
                else {
                    // phone no update
                    if(isset($existsUserDataArr[$newMemberComboKey])){
                        $memberUserSocietyId = $existsUserDataArr[$newMemberComboKey]['user_society_id'];
                        $userSocietyMemberId = $existsUserDataArr[$newMemberComboKey]['type_id'];
                        if($newMember['mobile_no'] != $existsUserDataArr[$newMemberComboKey]){
                            if(empty($newMember['mobile_no'])){
                                $deleteUserSocietyIdArr[] = $userSocietyMemberId;
                            } else {
                                $tblUsrSocietyUpadteArr[] = array(
                                    'user_society_id' => $memberUserSocietyId,
                                    'phone' => $newMember['mobile_no'],
                                );
                            }
                        }
                        continue;
                    }

                    // member id changed
                    if(isset($oldMemberArr[$newComboKey])){
                        $oldMemberId = $oldMemberArr[$newComboKey]['member_id'];
                        $newMemberId = $newMember['member_id'];
                        // $oldMemberComboKey = $oldMemberArr[$newComboKey]['society_id'].'|'.$oldMemberArr[$newComboKey]['resource_type_id'].'|'.$oldMemberArr[$newComboKey]['member_id'];
                        // $oldUserSocietyId = $existsUserDataArr[$oldMemberComboKey]['user_society_id'];
                        if($oldMemberId != $newMemberId){
                            $deleteUserSocietyIdArr[] = $oldMemberId;
                        }
                    }

                    if(isset($existsUserMobileNoWiseArr[$newMember['mobile_no']])){
                        // new entry if not in user society
                        if(!isset($existsUserMemberDataArr[$newMemberComboKey])) {
                            $password = PASSWORD;
                            $slugSociety = random_string();
                            // $slug = $existsUserMemberDataArr[$newMemberComboKey]['slug'];
                            $slug = $existsUserMobileNoWiseArr[$newMember['mobile_no']][0]['slug'];
                            $tblUsrGroupArr[] = [
                                'id' => '',
                                'group_id' => $groupId,
                                'slug' => $slug,
                            ];
                    
                            $tblUsrSocietyInsertArr[] = [
                                'user_society_id' => '',
                                'society_id' => $societyId,
                                'phone' => $newMember['mobile_no'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $newMember['member_id'],
                                'slug' => $slug,
                                'society_slug' => $slugSociety,
                            ];
                    
                            foreach ($permissionLabel as $labelData) {
                                list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                if (in_array($permissionValue, $permissionArray)) {
                                    $tblUsrPermissionArr[] = [
                                        'controller_name' => $controller,
                                        'permission_name' => $permissionValue,
                                        'permission_label' => $label,
                                        'group_id' => $resourceTypeMemberData['group_id'],
                                        'slug' => $slug,
                                        'society_slug' => $slugSociety,
                                        'created_at' => date('Y-m-d H:i:s'),
                                        'created_by' => $this->session->get('user_id'),
                                        'updated_at' => date('Y-m-d H:i:s'),
                                        'updated_by' => $this->session->get('user_id'),
                                    ];
                                }
                            }
                        }
                    } else {
                        // New User
                        $password = PASSWORD;
                        $slug = random_string();
                        $slugSociety = random_string();
                        if(!empty($newMember['mobile_no'])){
                            $tblUsrInsertArr[] = [
                                'username' => $newMember['email_id'],
                                'email' => $newMember['email_id'],
                                'first_name' => $newMember['name'],
                                // 'phone' => $newMember['mobile_no'],
                                'user_type_id' => $newMember['member_id'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'password' => $this->ionAuthModel->hashPassword($password),
                                'active' => 1,
                                'slug' => $slug,
                            ];
                    
                            $tblUsrGroupArr[] = [
                                'id' => '',
                                'group_id' => $groupId,
                                'slug' => $slug,
                            ];
                    
                            $tblUsrSocietyInsertArr[] = [
                                'user_society_id' => '',
                                'society_id' => $societyId,
                                'phone' => $newMember['mobile_no'],
                                'resource_type_id' => $resourceTypeMemberData['resource_type_id'],
                                'type_id' => $newMember['member_id'],
                                'slug' => $slug,
                                'society_slug' => $slugSociety,
                            ];
                    
                            foreach ($permissionLabel as $labelData) {
                                list($permissionValue, $controller, $label) = explode("|dt|", $labelData);
                                if (in_array($permissionValue, $permissionArray)) {
                                    $tblUsrPermissionArr[] = [
                                        'controller_name' => $controller,
                                        'permission_name' => $permissionValue,
                                        'permission_label' => $label,
                                        'group_id' => $resourceTypeMemberData['group_id'],
                                        'slug' => $slug,
                                        'society_slug' => $slugSociety,
                                        'created_at' => date('Y-m-d H:i:s'),
                                        'created_by' => $this->session->get('user_id'),
                                        'updated_at' => date('Y-m-d H:i:s'),
                                        'updated_by' => $this->session->get('user_id'),
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            // Execute all batch operations
            if (!empty($tblUsrUpdateArr)) {
                $this->ownershipFlatModel->batchUpdate($tblUsrUpdateArr, 'id', 'tbl_users');
            }
            if (!empty($tblUsrInsertArr)) {
                $this->ownershipFlatModel->batchInsert($tblUsrInsertArr, 'tbl_users');
            }
            if (!empty($tblUsrGroupArr)) {
                $this->ownershipFlatModel->batchInsert($tblUsrGroupArr, 'tbl_users_groups');
            }
            if (!empty($tblUsrSocietyInsertArr)) {
                $this->ownershipFlatModel->batchInsert($tblUsrSocietyInsertArr, 'tbl_user_society');
            }
            if (!empty($tblUsrSocietyUpadteArr)) {
                $this->ownershipFlatModel->batchUpdate($tblUsrSocietyUpadteArr,'user_society_id', 'tbl_user_society');
            }
            if (!empty($tblUsrPermissionArr)) {
                $this->ownershipFlatModel->batchInsert($tblUsrPermissionArr, 'tbl_user_permission');
            }
            if (!empty($deleteUserSocietyIdArr)) {
                $this->ownershipFlatModel->deleteUserIdRecords(array(
                    'member_id' => $deleteUserSocietyIdArr,
                ));
            }
            
            // Refresh mapping IDs
            $this->resourceTypeModel->updateUserGroupId();
            $this->resourceTypeModel->updateUserSocietyId();
            $this->resourceTypeModel->updateUserPermissionId();
            $this->resourceTypeModel->updateUserPermissionSocietyId();

            $ownershipFlatMemberFilterArray = array(
                'ownership_flat_member_id' => $lastOwnershipFlatMemberId,
                'is_show_all_member' => 1,
            );
            $memberInsertData = array();
            $ownershipFlatMemberInsertData = $this->ownershipFlatModel->getOwnershipFlatMemberData($ownershipFlatMemberFilterArray);
            if (!empty($ownershipFlatMemberInsertData)) {
                $memberInsertData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'type' => $ownershipFlatMemberInsertData['type'],
                    'type_id' => $ownershipFlatMemberInsertData['type_id'],
                    'is_show_all_member' => 1,
                    'is_active' => 1,
                    'is_multiple' => 1
                ));
            }
            if (!empty($memberInsertData)) {
                foreach ($memberInsertData as $vKey => $member) {
                    $formattedRelation = getFunctionKeyValue($member['relation'], relation());
                    // $formattedFoodLike = getFunctionKeyValue($member['food_like'], foodLike());
                    $formattedBloodGroup = getFunctionKeyValue($member['blood_group'], bloodGroupType());
                    $memberPath = site_url('uploads/no_image.png');
                    $memberThumbnailPath = site_url('uploads/no_image.png');
                    if ($member['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $memberPath = site_url() . FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    if ($member['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'])) {
                        $memberThumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $member['member_image'];
                    }
                    $memberInsertData[$vKey]['member_image'] = $memberPath;
                    $memberInsertData[$vKey]['thumbnail_member_image'] = $memberThumbnailPath;
                    $memberInsertData[$vKey]['gender_display'] = underscoreToUcWord($member["gender"]);
                    $memberInsertData[$vKey]['relation'] = $formattedRelation;
                    // $memberInsertData[$vKey]['food_like'] = $formattedFoodLike;
                    $memberInsertData[$vKey]['blood_group'] = $formattedBloodGroup;
                    $memberInsertData[$vKey]['relation_display'] = underscoreToUcWord($member["relation"]);
                    $memberInsertData[$vKey]['food_like_display'] = underscoreToUcWord($member["food_like"]);
                    $memberInsertData[$vKey]['birth_date_display'] = isValidDate($member['birth_date']) ? YMDToDMY($member["birth_date"]) : "";
                }
            }
            
            if (isset($isEdit) && !empty($isEdit)) {
                if (isset($memberData['success']) && $memberData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.document_updated'), lang('CommonWebService.member')),
                        'data' => $memberInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_update'), lang('CommonWebService.member')),
                        'data' => null
                    ), 404);
                }
            } else {
                if (isset($memberData['success']) && $memberData['success']) {
                    $this->db->transCommit();
                    return $this->response(array(
                        'status' => true,
                        'response_code' => 200,
                        'message' => sprintf(lang('CommonWebService.new_created'), lang('CommonWebService.member')),
                        'data' => $memberInsertData
                    ), 200);
                } else {
                    $this->db->transRollback();
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.member')),
                        'data' => null
                    ), 400);
                }
            }
        }
    }

    public function chehckAlreadyExistsNumber(){
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $mobileNo = $this->request->getVar('mobile_no');
        $memberId = $this->request->getVar('member_id');
    
        if(!empty($mobileNo)){
            // get resource data
            $existsResourceData = $this->resourceModel->getResourceData(array(
                "resource_mobile_no" => $mobileNo,
                "society_id" => $societyId,
            ));
            
            if(!empty($existsResourceData)) {
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('OwnershipFlat.mobile_no_already_used_resource'),
                    'data' => null
                ), 404);
            }
    
            // Get manager Data
            $resourceTypeManagerId = getResourceTypeId(RESOURCE_TYPE_MANAGER);
            $resourceTypeMemberId = getResourceTypeId(RESOURCE_TYPE_MEMBER);

            if(!empty($resourceTypeManagerData)){
                $userManagerDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
                    'phone' => $mobileNo,
                    'resource_type_id' => $resourceTypeManagerId,
                    'is_multiple' => 1 
                ));
            }
    
            if(!empty($userManagerDataArray)){
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => lang('OwnershipFlat.mobile_no_already_used_manager'),
                    'data' => null
                ), 404);
            }
    
            // get member data
            $userMemberDataArray = $this->commonWebserviceModel->getUserSocietyData(array(
                'phone' => $mobileNo,
                'is_member' => 1,
            ));
        }

        if (isset($userMemberDataArray) && !empty($userMemberDataArray)) {
            return $this->response(array(
                'status' => true,
                'response_code' => 200,
                'message' => lang('OwnershipFlat.mobile_no_already_used_member'),
                'data' => $userMemberDataArray
            ), 200);
        } else {
            return $this->response(array(
                'status' => false,
                'response_code' => 404,
                'message' => "No Data Found",
                'data' => null
            ), 400);
        }

    }

    public function editCustomerProfile() // Not
    {
        $this->db->transBegin();
        $dt_ci_file_upload = new \App\Libraries\Dt_ci_file_upload();
        $userId = $this->request->getVar('user_id');
        $societyId = $this->request->getVar('society_id');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
        $memberImage = $this->request->getVar('member_image');
        $this->validation->setRule('ownership_flat_member_id', lang('CommonWebService.ownership_flat_member_id'), 'required');
        $this->validation->setRule('society_id', lang('CommonWebService.society_id'), 'required');
        $this->validation->setRule('user_id', lang('CommonWebService.user_id'), 'required');
        if (!$this->validation->withRequest($this->request)->run()) {
            $errors = $this->validation->getErrors();
            //return $this->respond(array(
            return $this->response(array(
                    'status' => FALSE,
                    'message' => trim(preg_replace("/\r\n|\r|\n/", ',', implode("\n", $errors)), ","),
                    'data' => null,
                    'response_code' => 400,
                )
                , 400);
        } else {
            if (isset($_FILES["member_image"])) {
                $memberImagePath = FLAT_MEMBER_IMAGE_PATH;
                $memberImageResult = $dt_ci_file_upload->uploadFile('member_image', MAX_IMAGE_SIZE_LIMIT, $memberImagePath, true, true, array('jpeg', 'png', 'jpg'),true,true);
                if ($memberImageResult['success'] == false) {
                    return $this->response(array(
                        'status' => false,
                        'response_code' => 404,
                        'message' => strip_tags($memberImageResult['message']),
                        'data' => null
                    ), 404);
                } else {
                    $memberImageRecord = $memberImageResult['file_name'];
                    unset($memberImageResult['success']);
                    $thumbnailResult =  $dt_ci_file_upload->ThumbnailUploadFile($memberImageResult, FLAT_MEMBER_IMAGE_PATH, THUMBNAIL_FLAT_MEMBER_IMAGE_PATH);
                }
            }
            if (isset($memberImageRecord)) {
                $memberUpdateArray = array();
                $memberArray = array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                );
                $ownershipFlatMemberData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                    'ownership_flat_member_id' => $ownershipFlatMemberId,
                    'is_show_all_member' => 1,
                    'is_active' => 1
                ));
                $memberUpdateArray = $ownershipFlatMemberData;
                if ($ownershipFlatMemberData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberData['member_image'])) {
                    unlink(FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberData['member_image']);
                }
                if ($ownershipFlatMemberData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberData['member_image'])) {
                    unlink(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $ownershipFlatMemberData['member_image']);
                }
                $memberArray['member_image'] = $memberImageRecord;
                $memberUpdateArray = compareArray($memberArray, $memberUpdateArray);
                $extraData = array();
                $extraObj['api_user_id'] = $userId;
                $extraObj['society_id'] = $societyId;
                $extraData['is_api_data'] = $extraObj;
                $memberData = $this->commonWebserviceModel->insertUpdateRecord($memberArray, 'ownership_flat_member_id', 'tbl_ownership_flat_member', 1, '', array(), $extraData, $memberUpdateArray);

            }
            $memberProfileData = $this->ownershipFlatModel->getOwnershipFlatMemberData(array(
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'is_active' => 1,
                'is_show_all_member' => 1
            ));
            if (!empty($memberProfileData)) {
                $path = site_url('uploads/no_image.png');
                $thumbnailPath = site_url('uploads/no_image.png');
                if ($memberProfileData['member_image'] != '' && file_exists(FLAT_MEMBER_IMAGE_PATH . $memberProfileData['member_image'])) {
                    $path = site_url() . FLAT_MEMBER_IMAGE_PATH . $memberProfileData['member_image'];
                }
                if ($memberProfileData['member_image'] != '' && file_exists(THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberProfileData['member_image'])) {
                    $thumbnailPath = site_url() . THUMBNAIL_FLAT_MEMBER_IMAGE_PATH . $memberProfileData['member_image'];
                }
                $memberProfileData['thumbnail_member_image'] = $thumbnailPath;
                $memberProfileData['member_image'] = $path;
            }
            if (!empty($memberProfileData)) {
                $this->db->transCommit();
                return $this->response(array(
                    'status' => true,
                    'response_code' => 200,
                    'message' => lang('CommonWebService.profile_updated_successfully'),
                    'data' => $memberProfileData
                ), 200);
            } else {
                $this->db->transRollback();
                return $this->response(array(
                    'status' => false,
                    'response_code' => 404,
                    'message' => sprintf(lang('CommonWebService.failed_to_create'), lang('CommonWebService.no_data_found')),
                    'data' => $memberProfileData
                ), 400);
            }
        }
    }


    public function sendBulk()
    {
//      $userIds = ['6c522c3a-5a4b-4c0e-ace4-ca77637f3d11', '6d50d161-320e-4002-a895-40e1e7e07acb']; // Add the player IDs here
//      $heading = 'Notification Title';
//      $message = 'This is a bulk notification message.';
//
//      $response = testNo($heading, $message, $userIds);

        return json_encode($response);
    }

    function _remap($method)
    {
        // Sure it exists, but can they do anything with it?
        if (!method_exists($this, $method)) {
            $data = array(
                'status' => false,
                'message' => "Unknown method",
                'response_code' => 405,
                'data' => null,
            );
            return $this->response($data, 405);
        }

        if (method_exists($this, $method)) {
            $this->logRequest($authorized = TRUE);
            return $this->$method();
        }
    }

    protected function logRequest($authorized = FALSE, $response = "")
    {
        $request = request();
        $header = $request->Header('Authorization');
        if ($header != '') {
            if (!empty($header)) {
                if (preg_match('/Bearer\s(\S+)/', $header, $matches)) {
                    $token = $matches[1];
                }
            }
            $requestArray = array();
            $requestArray = $request->getVar();
            $requestArray['Authorization'] = $token;
            $params = $requestArray;
        } else {
            $params = $request->getVar();
        }

        $builder = $this->db->table('tbl_logs');
        $data['uri'] = uri_string();
        $data['method'] = $this->request->getMethod();
        $data['params'] = json_encode($params);
        $data['api_key'] = '';
        $data['ip_address'] = $request->getIPAddress();
        $data['time'] = time();
        $data['authorized'] = $authorized;
        $data['response'] = $response;
        $data['request_time'] = date("Y-m-d h:i:s");
        // Insert the request into the log table
        $builder->insert($data);
        $this->insertId = $this->db->insertID();

    }

    protected function logAccessTime()
    {
        if ($this->insertId == '') {
            return false;
        }

        $payload['rtime'] = $this->endRtime - $this->startRtime;
        $builder = $this->db->table('tbl_logs');

        $builder->where('id', $this->insertId);
        $builder->update($payload);
    }

    protected function logResponseCode($http_code, $output)
    {
        if ($this->insertId == '') {
            return false;
        }

        $payload['response_code'] = $http_code;
        $payload['response'] = $output;
        $payload['responsetime'] = time();
        $payload['response_time'] = date("Y-m-d h:i:s");

        $builder = $this->db->table('tbl_logs');

        $builder->where('id', $this->insertId);
        $builder->update($payload);
    }

    function response($data = array(), $http_code = NULL, $continue = FALSE)
    {

        if ($http_code !== NULL) {
            // So as to be safe later on in the process
            $http_code = (int)$http_code;
        }
        // Set the output as NULL by default
        $output = NULL;

        // If data is NULL and no HTTP status code provided, then display, error and exit
        if ($data === NULL && $http_code === NULL) {
            $http_code = 404;
        } // If data is not NULL and a HTTP status code provided, then continue
        elseif ($data !== NULL) {
            $output = json_encode($data);
        }

        // If not greater than zero, then set the HTTP status code as 200 by default
        // Though perhaps 500 should be set instead, for the developer not passing a
        // correct HTTP status code
        $http_code > 0 || $http_code = 200;
        // JC: Log response code only if rest logging enabled
        if (REST_ENABLE_LOGGING === TRUE) {
            $this->logResponseCode($http_code, $output);
        }
        return $this->respond($data, $http_code);
    }
}

?>
